package FEJDGui;
import FEJDMath.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** Panel of the right side of the window which contains the buttons to solve the problem (and to change the speed of the display) */
public class ButtonPanel extends JPanel implements ActionListener, AdjustmentListener {

	/** The button to assemble the matrix */
	public JButton matButton;
	/** The button to compute boundary conditions of the first type */
	public JButton bc1Button;
	/** The button to compute boundary conditions of the second type */
	public JButton bc2Button;
	/** The button to compute boundary conditions of the third type */
	private JButton bc3Button;
	/** The button to compute solution of the problem */
	private JButton solButton;
	/** Stores if the display should be showing the solution or not */
	public boolean isDisplayingSol = false;
	/** Stores if the display should be showing the LU decomposition or not */
	public boolean isTimeToDisplayLU = false;
	/** The scroll bar used to set the speed */
	private JScrollBar speed;
	/** The label on which "speed" is written */
	private JLabel speedLabel;
	/** Stores if the threads are allowed to run or not */
	private boolean threadAllowed = false;
	/** Stores if the threads that refines the mesh is allowed to run or not */
	private boolean refineThreadAllowed = false;
	/** Stores if the threads that renumbers the mesh is allowed to run or not */
	private boolean renumberThreadAllowed = false;

	/** Construcs and initalizes a new button panel */
	public ButtonPanel() {

		speedLabel = new JLabel(Display.frame.MB.getString("Speed") + " :");

		matButton = new JButton(Display.frame.MB.getString("MatAss"));
		bc1Button = new JButton(Display.frame.MB.getString("BC1"));
		bc2Button = new JButton(Display.frame.MB.getString("BC2"));
		bc3Button = new JButton(Display.frame.MB.getString("BC3"));
		solButton = new JButton(Display.frame.MB.getString("Solve"));

		speed = new JScrollBar(Adjustable.HORIZONTAL, Mesh.TIMESLEEP, 1000, 0, 5000);
		speed.setUnitIncrement(50);
		speed.setBlockIncrement(400);
		speed.addAdjustmentListener(this);

		matButton.addActionListener(this);
		bc1Button.addActionListener(this);
		bc2Button.addActionListener(this);
		bc3Button.addActionListener(this);
		solButton.addActionListener(this);

		matButton.setToolTipText(Display.frame.MB.getString("Mat_ttt"));
		bc1Button.setToolTipText(Display.frame.MB.getString("BC1_ttt"));
		bc2Button.setToolTipText(Display.frame.MB.getString("BC2_ttt"));
		bc3Button.setToolTipText(Display.frame.MB.getString("BC3_ttt"));
		solButton.setToolTipText(Display.frame.MB.getString("Sol_ttt"));
		speed.setToolTipText(Display.frame.MB.getString("Speed_ttt"));

		matButton.setAlignmentX((float)0.5);
		bc1Button.setAlignmentX((float)0.5);
		bc2Button.setAlignmentX((float)0.5);
		bc3Button.setAlignmentX((float)0.5);
		solButton.setAlignmentX((float)0.5);
		speed.setAlignmentX((float)0.5);

		matButton.setEnabled(false);
		bc1Button.setEnabled(false);
		bc2Button.setEnabled(false);
		bc3Button.setEnabled(false);
		solButton.setEnabled(false);

		Box b = Box.createVerticalBox();
		b.add(matButton);
		b.add(Box.createVerticalStrut(10));
		b.add(bc2Button);
		b.add(Box.createVerticalStrut(10));
		b.add(bc3Button);
		b.add(Box.createVerticalStrut(10));
		b.add(bc1Button);
		b.add(Box.createVerticalStrut(10));
		b.add(solButton);
		b.add(Box.createVerticalStrut(25));;

		Box hb = Box.createHorizontalBox();
		hb.add(speedLabel);
		hb.add(Box.createHorizontalStrut(10));
		hb.add(speed);
		b.add(hb);

		add(b);
	}

	/** Enables the right button after load */
	public void LoadButton() {
		matButton.setEnabled(true);
		bc2Button.setEnabled(false);
		bc3Button.setEnabled(false);
		solButton.setEnabled(false);
		bc1Button.setEnabled(false);
		if(MathStuff.getMesh().getElemType() == Data.TRIANGLE)
			Display.frame.MB.setRenumEnabled(true);
		else
			Display.frame.MB.setRenumEnabled(false);
		Display.frame.MeP.setElemRed(-1);
		Display.frame.MeP.noRedBorder();
		Display.frame.MeP.setNodeRed(-1);
	}

	/** Updates the labels when the user changes the language */
	public void update() {
		matButton.setText(Display.frame.MB.getString("MatAss"));
		bc1Button.setText(Display.frame.MB.getString("BC1"));
		bc2Button.setText(Display.frame.MB.getString("BC2"));
		bc3Button.setText(Display.frame.MB.getString("BC3"));
		solButton.setText(Display.frame.MB.getString("Solve"));
		speedLabel.setText(Display.frame.MB.getString("Speed") + " :");

		matButton.setToolTipText(Display.frame.MB.getString("Mat_ttt"));
		bc1Button.setToolTipText(Display.frame.MB.getString("BC1_ttt"));
		bc2Button.setToolTipText(Display.frame.MB.getString("BC2_ttt"));
		bc3Button.setToolTipText(Display.frame.MB.getString("BC3_ttt"));
		solButton.setToolTipText(Display.frame.MB.getString("Sol_ttt"));
		speed.setToolTipText(Display.frame.MB.getString("Speed_ttt"));
	}

	/** Returns the step of the solving process of the problem */
	public int getState() {
		if (matButton.isEnabled())
			return 0;
		else if (bc2Button.isEnabled())
			return 1;
		else if (bc3Button.isEnabled())
			return 2;
		else if (bc1Button.isEnabled())
			return 3;
		else if (solButton.isEnabled())
			return 4;
		else if (isDisplayingSol)
			return 5;
		else // ne devrait pas arriver...
			return 0;
	}

	/** Reacts to a change of the speed scroll bar */
	public void adjustmentValueChanged(AdjustmentEvent evt) {
		Mesh.TIMESLEEP = speed.getValue();
	}

	/** Returns true if the computing threads are allowed to run */
	public boolean isThreadAllowed() {
		return threadAllowed;
	}

	/** Stops the computing threads */
	public void stopAllThreads() {
		refineThreadAllowed = false;
		renumberThreadAllowed = false;
		threadAllowed = false;
		Thread.yield(); // to let them terminate
	}

	/** Returns true if the refining thread is allowed to run */
	public boolean isRefineThreadAllowed() {
		return refineThreadAllowed;
	}

	/** Returns true if the renumbering thread is allowed to run */
	public boolean isRenumberThreadAllowed() {
		return renumberThreadAllowed;
	}

	/** Allows the renumbering thread to run */
	public void allowRenumberThread() {
		renumberThreadAllowed = true;
	}

	/** Allows the renumbering thread to run */
	public void allowRefineThread() {
		refineThreadAllowed = true;
	}

	/** Allows the renumbering thread to run */
	public void allowThread() {
		threadAllowed = true;
	}

	/** Disables all the buttons of the panel */
	public void disableAllButtons()
	{
		matButton.setEnabled(false);
		bc2Button.setEnabled(false);
		bc3Button.setEnabled(false);
		bc1Button.setEnabled(false);
		solButton.setEnabled(false);
	}

	/** Cleans up when the thread for assembling the matrix has finished */
	public void cleanUpMat() {
		bc2Button.setEnabled(true);
		Display.frame.MeP.setElemRed(-1);
		Display.frame.MeP.repaint();
		Display.frame.MaP.repaint();
		threadAllowed = false;
	}

	/** Cleans up when the thread for computing the conditions of second type has finished */
	public void cleanUpBC2() {
		bc3Button.setEnabled(true);
		Display.frame.MeP.noRedBorder();
		Display.frame.MeP.repaint();
		Display.frame.MaP.repaint();
		threadAllowed = false;
	}
	/** Cleans up when the thread for computing the conditions of third type has finished */
	public void cleanUpBC3() {
		bc1Button.setEnabled(true);
		Display.frame.MeP.noRedBorder();
		Display.frame.MeP.repaint();
		Display.frame.MaP.repaint();
		threadAllowed = false;
	}
	/** Cleans up when the thread for computing the conditions of first type has finished */
	public void cleanUpBC1() {
		solButton.setEnabled(true);
		Display.frame.MeP.setNodeRed(-1);
		Display.frame.MaP.clearGreenTmp();
		Display.frame.MeP.repaint();
		Display.frame.MaP.repaint();
		threadAllowed = false;
	}

	/** Cleans up when the thread for computing the solution has finished */
	public void cleanUpSol(int fctType, int elemType) {
		if (fctType==Data.LINEAR && elemType==Data.TRIANGLE)
			Display.frame.MB.setRefinementEnabled(true);
		Display.frame.MB.setSolutionEnabled(true);
		refineThreadAllowed = true;
		renumberThreadAllowed = true;
		Display.frame.RP.setRefineSBEnabled(true);
		Display.frame.RP.makeSimpleTriangle(MathStuff.getMesh().getAllElem());
		Display.frame.MaP.clearRedTmp();
		isDisplayingSol = true;
		Display.frame.MeP.repaint();
		Display.frame.MaP.repaint();
	}

	/** Reacts to the user's click on a button */
	public void actionPerformed(ActionEvent evt) {
		Object source = evt.getSource();
		if (source == matButton) {
			threadAllowed = true;
			matButtonAction();
		}
		else if (source == bc2Button) {
			threadAllowed = true;
			bc2ButtonAction();
		}
		else if (source == bc3Button) {
			threadAllowed = true;
			bc3ButtonAction();
		}
		else if (source == bc1Button) {
			threadAllowed = true;
			bc1ButtonAction();
		}
		else if (source == solButton) {
			threadAllowed = true;
			solButtonAction();
		}
	}

	/** Performs the needed actions when the matrix button is pressed */
	public void matButtonAction() {
		if (Display.frame.MB.isQuadraticFctSelected() && Display.frame.MB.isAutoRenumSelected()) {
			renumberThreadAllowed = true;
			Renumbering.McKee(MathStuff.getMesh(), false);
		}
		threadAllowed = true;
		Display.frame.CP.printHTML("ass_matrix.html");
		matButton.setEnabled(false);
		MathStuff.makeMat();
	}

	/** Performs the needed actions when the matrix button is pressed */
	public void bc2ButtonAction() {
		while (MathStuff.isMatThreadAlive()) {
			try {Thread.sleep(10);}
			catch (Exception e) {}
		}
		threadAllowed = true;
		Display.frame.CP.printHTML("Neumann.html");
		bc2Button.setEnabled(false);
		MathStuff.calcBCT2();
	}


	/** Performs the needed actions when the matrix button is pressed */
	public void bc3ButtonAction() {
		while (MathStuff.isBCT2ThreadAlive()) {
			try {Thread.sleep(10);}
			catch (Exception e) {}
		}
		threadAllowed = true;
		Display.frame.CP.printHTML("Robin.html");
		bc3Button.setEnabled(false);
		MathStuff.calcBCT3();
	}

	/** Performs the needed actions when the matrix button is pressed */
	public void bc1ButtonAction() {
		while (MathStuff.isBCT3ThreadAlive()) {
			try {Thread.sleep(10);}
			catch (Exception e) {}
		}
		threadAllowed = true;
		Display.frame.CP.printHTML("Dirichlet.html");
		bc1Button.setEnabled(false);
		MathStuff.simulBCT1();
	}

	/** Performs the needed actions when the matrix button is pressed */
	public void solButtonAction() {
		while (MathStuff.isBCT1ThreadAlive()) {
			try {Thread.sleep(10);}
			catch (Exception e) {}
		}
		threadAllowed = true;
		Display.frame.CP.printHTML("Solution.html");
		solButton.setEnabled(false);
		MathStuff.solvePb();
	}

}
