package FEJDGui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import java.io.*;
import javax.swing.text.*;
import java.net.*;

/** Panel where some code is displayed in order to help the user understand the different setps of the solving process */
public class CodePanel extends JScrollPane
{

	/** The Pane on which the HTML are displayed */
	private JEditorPane editor;
	/** The name of the HTML file */
	private String fileName;

	/** Construts a new code panel */
	public CodePanel() {
		Border etched = BorderFactory.createEtchedBorder();
		Border titled = BorderFactory.createTitledBorder(etched, Display.frame.MB.getString("code"));
		setBorder(titled);

		editor = new JEditorPane();
		editor.setEnabled(false);
		editor.setBackground( Color.white );

		getViewport().add(editor);
		printHTML("Start.html");
	}

	/** Prints the String <tt>NameFile</tt> in the Panel */
	public void printHTML(String nameFile)
	{
		fileName = nameFile;
		displayHTML();
	}

	/** Displays the HTML file on the panel */
	public void displayHTML() {
		if(fileName != null || Display.frame.MB.isDisplayingDoc()) {
			try {
				if(!Display.frame.MB.isDisplayingDoc())
					editor.setPage(this.getClass().getClassLoader().getResource( Display.frame.MB.getString("prefix") + "/" + fileName ));
				else
					editor.setPage(this.getClass().getClassLoader().getResource( Display.frame.MB.getString("prefix") + "/" + "Doc.html" ));
			}
			catch( Exception e )
			{
				clear();
			}
		}
	}

	/** Clears the text of the panel */
	public void clear() {
		editor.setText("");
	}

	/** Sets the background to white */
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		setBackground(Color.white);
	}

	/** Updates the labels when the user changes the language */
	public void update() {
		Border etched = BorderFactory.createEtchedBorder();
		Border titled = BorderFactory.createTitledBorder(etched, Display.frame.MB.getString("code"));
		setBorder(titled);
		displayHTML();
	}

}
