package FEJDGui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

/** Main frame : it initiates and loads all the other panels */
public class Display {

	/** The mesh panel of the main window */
	public MeshPanel MeP;
	/** The matrix panel of the main window */
	public MatrixPanel MaP;
	/** The load panel of the main window */
	public OurLoadPanel LP;
	/** The code panel of the main window */
	public CodePanel CP;
	/** The button panel of the main window */
	public ButtonPanel BP;
	/** The mesh refine of the main window */
	public RefinePanel RP;
	/** The zoom panel of the main window */
	public ZoomPanel ZP;
	/** The menu bar of the main window */
	public OurMenuBar MB;
	/** Variable used to keep a reference to the instance of display */
	public static Display frame; // It has to be called from a static context but cannot be called through FEJavaDemo
	/** The scroll pane which contains the matrix panel */
	public JScrollPane SP;
	/** The vertical header of the scroll pane */
	public RulerPanel VRP;
	/** The horizontal header of the scroll pane */
	public RulerPanel HRP;
	/** Variable used to keep a reference to the open frame or applet */
	private Container mainFrame;
	/** Variable used to store the about box */
	public AboutBox AB;

	/* static initializer to call the private constructor on the static singleton instance */
	static
	{
		frame = new Display();
	}

	/** Creates a new disaplay, initialize should then be called to initialize it */
	private Display()
	{
	}

	/** Constructs and initializes a new Display */
	public void initialize(Container c) {

		mainFrame = c;
		boolean isApplet;
		if(c instanceof JApplet)
			isApplet = true;
		else
			isApplet = false;

		if(isApplet)
		{
			MB = new WebMenuBar();
			LP = new WebLoadPanel();
			AB = new AboutBox(null);
		}
		else
		{
			MB = new PrgMenuBar();
			LP = new LoadPanel();
			AB = new AboutBox((JFrame)c);
		}


		MeP = new MeshPanel();
		CP = new CodePanel();
		BP = new ButtonPanel();
		RP = new RefinePanel();
		ZP = new ZoomPanel();
		MaP = new MatrixPanel();
		SP = new JScrollPane();
		VRP = new RulerPanel(0);
		HRP = new RulerPanel(1);
		JSplitPane JSP = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, SP, MeP);
		Border etched = BorderFactory.createEtchedBorder();
		Border titled = BorderFactory.createTitledBorder(etched, MB.getString("matrix"));
		SP.setBorder(titled);
		SP.setBackground(Color.white);

		SP.setViewportView(MaP);
		SP.setColumnHeaderView(HRP);
		SP.setRowHeaderView(VRP);

		if(!isApplet)
		{
			JFrame f =(JFrame)c;
			f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			f.setTitle("FEJavaDemo");

			Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
			f.setSize(dim.width, dim.height-50);

			JSP.setDividerLocation(dim.width/2);
		}

		JSP.setResizeWeight(.5);

		Container contentPane;
		if(isApplet)
			contentPane = ((JApplet)mainFrame).getContentPane();
		else
			contentPane = ((JFrame)mainFrame).getContentPane();

		GridBagLayout gbl = new GridBagLayout();
		contentPane.setLayout(gbl);

		GridBagConstraints gbc = new GridBagConstraints();

		gbc.weightx = 0;
		gbc.weighty = 0;
		add((JComponent)LP, gbc, 0, 0, 1, 1, contentPane);

		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 1;//100
		gbc.weighty = 0;
		add(CP, gbc, 1, 0, 2, 1, contentPane);

		gbc.fill = GridBagConstraints.NONE;
		gbc.weightx = 0;
		gbc.weighty = 0;
		add(BP, gbc, 3, 0, 1, 1, contentPane);


		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 1;//100
		add(ZP, gbc, 0, 1, 2, 1, contentPane);
		add(RP, gbc, 2, 1, 2, 1, contentPane);

		gbc.weightx = 1;//100
		gbc.weighty = 1;//100
		add(JSP, gbc, 0, 2, 4, 1, contentPane);

		if(isApplet)
			((JApplet)mainFrame).setJMenuBar((JMenuBar)MB);
		else
			((JFrame)mainFrame).setJMenuBar((JMenuBar)MB);

	}

	public void validate()
	{
		mainFrame.validate();
	}

	/** Updates the text of the scroll pane upon language change */
	public void update() {
		Border etched = BorderFactory.createEtchedBorder();
		Border titled = BorderFactory.createTitledBorder(etched, MB.getString("matrix"));
		SP.setBorder(titled);
	}

	/** Adds a component to the layout */
	private void add(Component c, GridBagConstraints gbc, int x, int y, int w, int h, Container contentPane) {
		gbc.gridx = x;
		gbc.gridy = y;
		gbc.gridwidth = w;
		gbc.gridheight = h;
		contentPane.add(c, gbc);
	}

	/** Method to get the JApplet containing this object
	 *  @throws ClassCastException if the container is not a JApplet */
	public JApplet getApplet() throws ClassCastException
	{
		return ((JApplet)mainFrame);
	}
}
