package FEJDGui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.ImageIO;


/** Frame that lets the user choose if he wants to create a jpeg file from the mesh or the matrix panel */
class JpegFrame extends JFrame implements ActionListener {

	/** The button to save the jpeg files */
	private JButton SaveButton;
	/** The button to cancel the process */
	private JButton CancelButton;
	/** The checkbox to tell is the user wants a jpeg of the matrix or not */
	private JCheckBox matCB;
	/** The checkbox to tell is the user wants a jpeg of the mesh or not */
	private JCheckBox meshCB;
	/** The checkbox to tell if the user wants to print the whole matrix */
	private JCheckBox partialCB;
	/** The field where the path to the matrix jpeg is written */
	private JTextField matName;
	/** The field where the path to the mesh jpeg is written */
	private JTextField meshName;

	/** Constructs and initializes a new jpeg frame */
	public JpegFrame() {
		setTitle(Display.frame.MB.getString("JPGFrameTitle"));
		setResizable(false);
		setBounds(200, 200, 400, 180);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				hide();
			}
		});
		Container contentPane = getContentPane();

		int state = Display.frame.BP.getState();

		partialCB = new JCheckBox(Display.frame.MB.getString("VisiblePart"), true);

		matCB = new JCheckBox("", true);

		if (state == 5)
			meshCB = new JCheckBox("", true);
		else
			meshCB = new JCheckBox("", false);

		if (Display.frame.MB.isDisplDecomp() && Display.frame.BP.isDisplayingSol )
			matName = new JTextField(Display.frame.LP.getSelectNetPath() + "_mat" + state + "_LU" + ".jpeg", 30);
		else
			matName = new JTextField(Display.frame.LP.getSelectNetPath() + "_mat" + state + ".jpeg", 30);

		meshName = new JTextField(Display.frame.LP.getSelectNetPath() + "_" + Display.frame.MB.getString("meshab") + ".jpeg", 30);

		SaveButton = new JButton(Display.frame.MB.getString("Save"));
		CancelButton = new JButton(Display.frame.MB.getString("Cancel"));

		SaveButton.addActionListener(this);
		CancelButton.addActionListener(this);

		JPanel p1 = new JPanel();
		p1.add(partialCB);
		contentPane.add(p1, "North");

		JPanel p21 = new JPanel();
		p21.add(matCB);
		p21.add(matName);

		JPanel p22 = new JPanel();
		p22.add(meshCB);
		p22.add(meshName);

		JPanel p2 = new JPanel();
		p2.add(p21, "North");
		p2.add(p22, "Center");
		contentPane.add(p2, "Center");

		JPanel p3 = new JPanel();
		p3.add(SaveButton);
		p3.add(CancelButton);
		contentPane.add(p3, "South");

	}

	/** Reacts to the user click on a button */
	public void actionPerformed(ActionEvent e) {
		Object quelle = e.getSource();

		if(quelle == SaveButton) {

			if (matCB.isSelected()) {
				int w, h;
				if (partialCB.isSelected()) {
					w = Display.frame.SP.getViewport().getWidth();
					h = Display.frame.SP.getViewport().getHeight();
				}
				else {
					w = Display.frame.MaP.getWidth();
					h = Display.frame.MaP.getHeight();
					Display.frame.MaP.willPaintAll();
				}

				try {
					BufferedImage image = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
					Graphics2D g = image.createGraphics();
					Display.frame.MaP.paint(g);
					g.dispose();

					ImageIO.write(image, "jpg", new File(matName.getText()));
				}
				catch(IOException ioe) {
					JOptionPane.showMessageDialog(null, Display.frame.MB.getString("Error"), Display.frame.MB.getString("UnableToSave"), JOptionPane.ERROR_MESSAGE);
				}
				catch(OutOfMemoryError er)
				{
					String msg = Display.frame.MB.getString("UnableToSaveJpeg");
					String title = Display.frame.MB.getString("MemoryError");
					JOptionPane.showMessageDialog(null, msg, title, JOptionPane.ERROR_MESSAGE);
				}
			}
			if (meshCB.isSelected()) {
				int w = Display.frame.MeP.getWidth();
				int h = Display.frame.MeP.getHeight();

				try {
					BufferedImage image = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
					Graphics2D g = image.createGraphics();
					Display.frame.MeP.paint(g);
					g.dispose();

					ImageIO.write(image, "jpg", new File(meshName.getText()));
				}
				catch(IOException ioe) {
					JOptionPane.showMessageDialog(null, Display.frame.MB.getString("Error"), Display.frame.MB.getString("UnableToSave"), JOptionPane.ERROR_MESSAGE);
				}
				catch(OutOfMemoryError er)
				{
					String msg = Display.frame.MB.getString("UnableToSaveJpeg");
					String title = Display.frame.MB.getString("MemoryError");
					JOptionPane.showMessageDialog(null, msg, title, JOptionPane.ERROR_MESSAGE);
				}
			}
			hide();
		}
		else if(quelle == CancelButton)
			hide();
	}

}
