package FEJDGui;
import FEJDMath.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.File;


/** Panel used to select and load the files .dat and .net */
public class LoadPanel extends JPanel implements ActionListener, OurLoadPanel {

	/** File chooser for the .net file */
	private JFileChooser fileChooserNet;
	/** File chooser for the .dat file */
	private JFileChooser fileChooserDat;
	/** Button to browse for the .net file */
	private JButton browseBtn1;
	/** Button to browse for the .dat file */
	private JButton browseBtn2;
	/** Button to quit the program */
	private JButton quitBtn;
	/** Text field which displays the path of the .net file  */
	private JTextField tf1;
	/** Text field which displays the path of the .dat file  */
	private JTextField tf2;
	/** Button to load the two files  */
	private JButton loadBtn;
	/** Name of the .net file */
	private String fileName="File.net";
	/** Path of the .net file */
	private String filePath="File.net";

	/** Constructs and initialises a new load panel */
	public LoadPanel() {

		fileChooserNet = new JFileChooser(new File("."));
		fileChooserDat = new JFileChooser(new File("."));

		fileChooserNet.setFileFilter( new javax.swing.filechooser.FileFilter() {
			public boolean accept(File f) {
				return (f.getName().toLowerCase().endsWith(".net") || f.isDirectory());
			}
			public String getDescription() {
				return ".net Files";
			}
		});

		fileChooserDat.setFileFilter( new javax.swing.filechooser.FileFilter() {
			public boolean accept(File f) {
				return (f.getName().toLowerCase().endsWith(".dat") || f.isDirectory());
			}
			public String getDescription() {
				return ".dat Files";
			}
		});

		browseBtn1 = new JButton(Display.frame.MB.getString("Browse") + " .net");
		browseBtn2 = new JButton(Display.frame.MB.getString("Browse") + " .dat");
		loadBtn = new JButton(Display.frame.MB.getString("Load"));

		quitBtn = new JButton(Display.frame.MB.getString("Quit"));

		browseBtn1.addActionListener(this);
		browseBtn2.addActionListener(this);
		loadBtn.addActionListener(this);
		quitBtn.addActionListener(this);

		tf1 = new JTextField("", 8);
		tf2 = new JTextField("", 8);
		tf1.setHorizontalAlignment(JTextField.LEFT);
		tf1.setFont(new Font("SansSerif", Font.PLAIN, 12));
		tf2.setHorizontalAlignment(JTextField.LEFT);
		tf2.setFont(new Font("SansSerif", Font.PLAIN, 12));

		loadBtn.setAlignmentX(0.5F);
		browseBtn1.setAlignmentX(0.5F);
		browseBtn2.setAlignmentX(0.5F);
		quitBtn.setAlignmentX(0.5F);

		Box b = Box.createVerticalBox();
		b.add(quitBtn);
		b.add(Box.createVerticalStrut(15));
		b.add(tf1);
		b.add(browseBtn1);
		b.add(Box.createVerticalStrut(15));
		b.add(tf2);
		b.add(browseBtn2);
		b.add(Box.createVerticalStrut(15));
		b.add(loadBtn);

		add(b);
	}

	/** Adds a component to the display */
	private void add(Component c, GridBagConstraints gbc, int x, int y, int w, int h) {
		gbc.gridx = x;
		gbc.gridy = y;
		gbc.gridwidth = w;
		gbc.gridheight = h;
		add(c, gbc);
	}

	/** Upadtes the text upon language change */
	public void update() {
		browseBtn1.setText(Display.frame.MB.getString("Browse") + " .net");
		browseBtn2.setText(Display.frame.MB.getString("Browse") + " .dat");
		loadBtn.setText(Display.frame.MB.getString("Load"));
		quitBtn.setText(Display.frame.MB.getString("Quit"));
	}

	/** Changes the value of the text field */
	private void setFieldTxt(JTextField tf, String txt) {
		tf.setText(txt);
	}

	/** Sets the selected net file to filetxt */
	public void setNetFile(String filetxt) {
		fileChooserNet.setSelectedFile(new File(filetxt));
		tf1.setText(filetxt);
	}

	/** Sets the selected net file to filetxt */
	public void setDatFile(String filetxt) {
		fileChooserDat.setSelectedFile(new File(filetxt));
		tf2.setText(filetxt);
	}

	/** Reponds to the user's click on a button */
	public void actionPerformed(ActionEvent ae) {
		Object quelle = ae.getSource();

		if (quelle == browseBtn1) {
			int ret = fileChooserNet.showOpenDialog(this);
			if(ret == JFileChooser.APPROVE_OPTION) {
				setFieldTxt(tf1, fileChooserNet.getSelectedFile().getPath());
				fileName = fileChooserNet.getSelectedFile().getName();
				filePath = fileChooserNet.getSelectedFile().getPath();
				fileChooserDat.setCurrentDirectory(fileChooserNet.getSelectedFile().getParentFile());
			}

		}
		else if (quelle == browseBtn2) {
			int ret = fileChooserDat.showOpenDialog(this);
			if(ret == JFileChooser.APPROVE_OPTION)
			{
				setFieldTxt(tf2, fileChooserDat.getSelectedFile().getPath());
				fileChooserNet.setCurrentDirectory(fileChooserDat.getSelectedFile().getParentFile());
			}
		}
		else if (quelle == loadBtn)
			loadButtonAction();
		else if (quelle == quitBtn)
			System.exit(0);
	}

	/** Performs the action of the load button */
	public void loadButtonAction() {
		Display.frame.BP.stopAllThreads();
		Display.frame.RP.stopThread();

		if (Display.frame.MB.isLinearFctSelected())
			MathStuff.setMesh(new Mesh(Data.LINEAR));
		else if (Display.frame.MB.isQuadraticFctSelected())
			MathStuff.setMesh(new Mesh(Data.QUADRATIC));

		Readers reader = new Readers();

		reader.readFile(MathStuff.getMesh(), tf1.getText(), tf2.getText(), false);
		Mesh m = MathStuff.getMesh();

		if (m != null) {
			Display.frame.MeP.setMesh(m);
			Display.frame.MaP.setMesh(m.getSize());

			Display.frame.BP.LoadButton();
			Display.frame.MB.setRefinementEnabled(false);
			Display.frame.MB.setSolutionEnabled(false);
			Display.frame.MB.setJpegEnabled(true);
			Display.frame.MB.setNewFileRenumEnabled(true);

			Display.frame.RP.LoadButton();
			Display.frame.BP.isDisplayingSol = false;
			Display.frame.BP.isTimeToDisplayLU = false;

			Display.frame.MaP.emptyVect();
			Display.frame.MaP.emptyMat();

			Display.frame.MeP.repaint();
			Display.frame.MaP.repaint();

			Display.frame.CP.clear();
		}
	}
	
	/** Returns the path of the selected file without .net */
	public String getSelectNetPath() {
		int end = tf1.getText().length()-4;
		return tf1.getText().substring(0, end);
	}

	/** Returns the name of the selected file without .dat */
	public String getSelectDatPath() {
		int end = tf2.getText().length()-4;
		return tf2.getText().substring(0, end);
	}

}
