package FEJDGui;
import FEJDMath.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

/** This panel displays the matrix with the painted elements */
public class MatrixPanel extends JPanel
{

	/** Keeps the choice of the user about the displaying of the LU decomposition */
	private boolean isDispDecomp=true;

	/** Contains non zero elements of the vector */
	private Vector vectBlue = new Vector();
	/** Contains the non zero elements of the vector added by the current element */
	private Vector vectRed = new Vector();
	/** Contains the elements of the vector corresponding to dirichlet nodes */
	private Vector vectGreen = new Vector();
	/** Contains non zero elements of the matrix */
	private Vector matBlue = new Vector();
	/** Contains non zero elements of the LU matrix after decomposition */
	private Vector matDecompBlue = new Vector();
	/** Contains the non zero elements of the matrix added by the current element */
	private Vector matRed = new Vector();
	/** Contains the elements of the matrix corresponding to dirichlet nodes */
	private Vector matGreen = new Vector();
	/** Contains the row and the column of the current dirichlet point */
	private Vector matGreenTmp = new Vector();
	/** Contains the row and the column of the current highlighted row, for the display of the solving process */
	private Vector matRedTmp = new Vector();
	/** The margin around the matrix */
	private int margin = 20;
	/** The current value of the zoom */
	private int zoomValue = Display.frame.ZP.zoomMin;
	/** The size of the displayed matrix */
	private int size = 0;
	/** True if the whole panel has to be painted (to create a jpeg for exemple) */
	private boolean all = false;

	/** Construts and initialises a new matrix panel */
	public MatrixPanel()
	{
		vectBlue = new Vector();
		vectRed = new Vector();
		matBlue = new Vector();
		matDecompBlue = new Vector();
		matRed = new Vector();
		vectGreen = new Vector();
		matGreen = new Vector();
		matGreenTmp = new Vector();
	}


	/** Sets the mesh so its matrix can be displayed */
	public void setMesh(int size)
	{
		this.size = size;

		int ecart;

		setPreferredSize(new Dimension(0,0));
		Display.frame.MaP.invalidate();
		Display.frame.validate();

		Dimension dim = this.getSize();
		int largscreen = (int)dim.getWidth();
		int hautscreen = (int)dim.getHeight();

		double zoomx = (double)(largscreen - 2 * margin)/(size+3);
		double zoomy = (double)(hautscreen - 2 * margin)/size;

		if (zoomx < zoomy)
			ecart = (int)zoomx;
		else
			ecart = (int)zoomy;

		ecart = Math.max(ecart, Display.frame.ZP.zoomMin);

		recalcPanelSize(ecart);
		Display.frame.ZP.setValueScroll(ecart);
	}

	/** Sets (i,j) as red element of the matrix */
	public void setMatRed(int i, int j) {
		matRed.add(new Vector2((double)i,(double)j));
	}
	/** Returns the ith red element of the matrix */
	private Vector2 getMatRed(int i) {
		return (Vector2)matRed.get(i);
	}
	/** Returns the ith blue element of the matrix */
	private Vector2 getMatBlue(int i) {
		return (Vector2)matBlue.get(i);
	}
	/** Returns the ith blue element of the LU matrix */
	private Vector2 getMatDecompBlue(int i) {
		return (Vector2)matDecompBlue.get(i);
	}
	/** Sets (i,j) as green element of the matrix */
	public void setMatGreen(int i, int j) {
		matGreen.add(new Vector2((double)i,(double)j));
	}
	/** Sets (i,j) as temporary green element of the matrix */
	public void setMatGreenTmp(int i, int j) {
		matGreenTmp.add(new Vector2((double)i,(double)j));
	}
	/** Sets (i,j) as temporary red element of the matrix */
	public void setMatRedTmp(int i, int j) {
		matRedTmp.add(new Vector2((double)i,(double)j));
	}
	/** Returns the ith green element of the matrix */
	private Vector2 getMatGreen(int i) {
		return (Vector2)matGreen.get(i);
	}
	/** Returns the ith temporary red element of the matrix */
	private Vector2 getMatRedTmp(int i) {
		return (Vector2)matRedTmp.get(i);
	}
	/** Returns the ith temporary green element of the matrix */
	private Vector2 getMatGreenTmp(int i) {
		return (Vector2)matGreenTmp.get(i);
	}
	/** Returns the number of red elements of the matrix */
	private int getMatRedSize()
	{
		if (matRed == null)
			return 0;
		return matRed.size();
	}
	/** Returns the number of blue elements of the matrix */
	private int getMatBlueSize()
	{
		if (matBlue == null)
			return 0;
		return matBlue.size();
	}
	/** Returns the number of blue elements of the LU matrix */
	private int getMatDecompBlueSize()
	{
		if (matDecompBlue == null)
			return 0;
		return matDecompBlue.size();
	}
	/** Returns the number of green elements of the matrix */
	private int getMatGreenSize()
	{
		if (matGreen == null)
			return 0;
		return matGreen.size();
	}
	/** Returns the number of temporary green elements of the matrix */
	private int getMatGreenTmpSize()
	{
		if (matGreenTmp == null)
			return 0;
		return matGreenTmp.size();
	}
	/** Returns the number of temporary red elements of the matrix */
	private int getMatRedTmpSize()
	{
		if (matRedTmp == null)
			return 0;
		return matRedTmp.size();
	}
	/** Clears the matrices containing colored points */
	public void emptyMat()
	{
		matRed = new Vector();
		matRedTmp = new Vector();
		matBlue = new Vector();
		matGreen = new Vector();
		matGreenTmp = new Vector();
		matDecompBlue = new Vector();
	}
	/** Clears the matrix containing temporary green points */
	public void clearGreenTmp()
	{
		matGreenTmp = new Vector();
	}
	/** Clears the matrix containing temporary red points */
	public void clearRedTmp()
	{
		matRedTmp = new Vector();
	}

	/** Changes all the red point of the matrix to blue points */
	public void insertMat()
	{
		for(int i =0; i < matRed.size(); i++)
		{
			matBlue.add(matRed.get(i));
		}
		matRed = new Vector();
	}
	/** Sets i as red element of the vector */
	public void setVectRed(int i) {
		vectRed.add(new Integer(i));
	}
	/** Returns the ith red element of the vector */
	private int getVectRed(int i) {
		return ((Integer)vectRed.get(i)).intValue();
	}
	/** Returns the ith blue element of the vector */
	private int getVectBlue(int i) {
		return ((Integer)vectBlue.get(i)).intValue();
	}
	/** Sets i as green element of the vector */
	public void setVectGreen(int i) {
		vectGreen.add(new Integer(i));
	}
	/** Returns the ith green element of the vector */
	private int getVectGreen(int i) {
		return ((Integer)vectGreen.get(i)).intValue();
	}
	/** Returns the number of green elements of the vector */
	private int getVectRedSize()
	{
		if (vectRed == null)
			return 0;

		return vectRed.size();
	}
	/** Returns the number of blue elements of the vector */
	private int getVectBlueSize()
	{
		if (vectBlue == null)
			return 0;

		return vectBlue.size();
	}
	/** Returns the number of green elements of the vector */
	private int getVectGreenSize()
	{
		if (vectGreen == null)
			return 0;

		return vectGreen.size();
	}
	/** Clears the vectors containing colored elements */
	public void emptyVect()
	{
		vectRed = new Vector();
		vectBlue = new Vector();
		vectGreen = new Vector();
	}

	/** Changes all the red point of the vector to blue elements */
	public void insertVect()
	{
		for(int i =0; i < vectRed.size(); i++)
		{
			vectBlue.add(vectRed.get(i));
		}
		vectRed = new Vector();
	}

	/** Returns the size of the matrix */
	public int getSizeMat()
	{
		return size;
	}

	/** Loads the LU decomposition of the matrix */
	public void loadDecomp(SkyLine SMatrix)
	{
		// loads the LU decomposition
		matDecompBlue = new Vector();

		for(int i=1; i <= size; i++)
		{
			for(int j=1; j <= i; j++)
			{
				if(SMatrix.get(i,j) != 0)
					matDecompBlue.add(new Vector2((double)i,(double)j));

			}
		}
	}

	/** Returns true if the element (i,j) of the matrix is displayed by the scroll pane */
	public boolean isElemDisplayed(int i, int j)
	{
		double ly = margin + (i-1) * zoomValue;
		double lx = margin + (j-1) * zoomValue;

		double rx = lx + zoomValue;
		double ry = ly + zoomValue;

		Rectangle rect = Display.frame.SP.getViewport().getViewRect();
		double rectlx = rect.getX();
		double rectrx = rect.getX() + rect.getWidth();
		double rectly = rect.getY();
		double rectry = rect.getY() + rect.getHeight();

		return (rx >= rectlx && lx <= rectrx && ry >= rectly && ly <= rectry);
	}

	/** Returns true if any portion of the row i and the column j is displayed by the scroll pane */
	public boolean isCrossDisplayed(int i, int j)
	{
		double ly = margin + (i-1) * zoomValue;
		double lx = margin + (j-1) * zoomValue;

		double rx = lx + zoomValue;
		double ry = ly + zoomValue;

		Rectangle rect = Display.frame.SP.getViewport().getViewRect();
		double rectlx = rect.getX();
		double rectrx = rect.getX() + rect.getWidth();
		double rectly = rect.getY();
		double rectry = rect.getY() + rect.getHeight();

		return ((rx >= rectlx && lx <= rectrx) || (ry >= rectly && ly <= rectry));

	}

	/** Recomputes the size of the matrix when the scroll bar is moved */
	public void recalcPanelSize(int value)
	{
		if(size > 0)
		{
			zoomValue = value;
			setPreferredSize(new Dimension((size+3) * value + 2 * margin , size * value + 2 * margin));

		}
		else
			setPreferredSize(Display.frame.SP.getViewport().getSize());
	}

	/** Switches between displaying and not displaying the LU matrix */
	public void changeDispDecomp()
	{
		isDispDecomp = !isDispDecomp;
		repaint();
	}

	/** Returns true if the user wants to display the LU matrix */
	public boolean getDispDecomp()
	{
		return isDispDecomp;
	}

	/** Returns the margin of the panel */
	public int getMargin()
	{
		return margin;
	}

	/** Prints the value of the element of the matrix */
	private void printValue(Graphics g, int ni, int nj, int xd, int yd, Color col, int asc, FontMetrics fm, boolean symetric)
	{
		g.setColor(col);

		double val = (int)(MathStuff.getMatrixValue(ni,nj)*10)/10.;
		String sval = String.valueOf(val);
		int swidth = fm.stringWidth(sval);

		g.drawString(sval, xd+(zoomValue-swidth)/2, yd+(zoomValue+asc)/2);

		if(nj != ni && symetric)
		{
			g.drawString(sval, yd+(zoomValue-swidth)/2, xd+(zoomValue+asc)/2);
		}
	}

	/** Prints the value of the element of the vector */
	private void printVectValue(Graphics g, int nbr, int xd, int yd, Color col, int asc, FontMetrics fm)
	{
		g.setColor(col);

		double val = (int)(MathStuff.getVectorValue(nbr)*10)/10.;
		String sval = String.valueOf(val);
		int swidth = fm.stringWidth(sval);

		g.drawString(sval, xd+(zoomValue-swidth)/2, yd+(zoomValue+asc)/2);
	}

	/** Turns the all variable to true */
	public void willPaintAll()
	{
		all = true;
	}

	/** Paints the components of the display */
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		setBackground(Color.white);
		
		if(size > 0)
		{
			int ecart = zoomValue;

			for(int i=0; i <= size; i++)
			{
				g.setColor(Color.black);

				int x1 = margin + i * ecart;
				int y1 = margin;

				int x2 = margin + i * ecart;
				int y2 = margin + size * ecart;

				g.drawLine(x1,y1,x2,y2);
				g.drawLine(y1,x1,y2,x2);

				// last vector
				x1 = margin + (size + 2) * ecart;
				y1 = margin + i * ecart;

				x2 = margin + (size + 3) * ecart;
				y2 = margin + i * ecart;

				g.drawLine(x1,y1,x2,y2);

			}

			// last vector
			int x1 = margin + (size + 2) * ecart;
			int y1 = margin;

			int x2 = margin + (size + 2) * ecart;
			int y2 = margin + size * ecart;

			g.drawLine(x1,y1,x2,y2);

			x1 = margin + (size + 3) * ecart;
			y1 = margin;

			x2 = margin + (size + 3) * ecart;
			y2 = margin + size * ecart;

			g.drawLine(x1,y1,x2,y2);


			Font f = new Font("SansSerif", Font.PLAIN, 14);
			g.setFont(f);
			FontMetrics fm = g.getFontMetrics(f);
			int asc = fm.getAscent();


			/*if(false && isDispDecomp && Display.frame.BP.isDisplayingSol)
			{
				for(int j=0; j < getMatDecompBlueSize(); j++)
				{
					int ni = (int)getMatDecompBlue(j).getNum(1);
					int nj = (int)getMatDecompBlue(j).getNum(2);

					if((isElemDisplayed(ni,nj) || isElemDisplayed(nj,ni)) || all)
					{

						int xd = margin + (ni-1) * ecart + 1;
						int yd = margin + (nj-1) * ecart + 1;

						g.setColor(Color.blue);
						g.fillRect(xd, yd, ecart-1, ecart-1);

						if(70 <= Display.frame.ZP.getValue())
						{
							printValue(g, ni, nj, xd, yd, Color.yellow, asc, fm);
						}
					}
				}
			}*/
			if(isDispDecomp && (Display.frame.BP.isTimeToDisplayLU || Display.frame.BP.isDisplayingSol))
			{
				for(int j=0; j < getMatDecompBlueSize(); j++)
				{
					int ni = (int)getMatDecompBlue(j).getNum(1);
					int nj = (int)getMatDecompBlue(j).getNum(2);

					if((isElemDisplayed(ni,nj) || isElemDisplayed(nj,ni)) || all)
					{

						int xd = margin + (ni-1) * ecart + 1;
						int yd = margin + (nj-1) * ecart + 1;

						g.setColor(Color.blue);
						g.fillRect(xd, yd, ecart-1, ecart-1);

						if(70 <= Display.frame.ZP.getValue())
						{
							printValue(g, ni, nj, xd, yd, Color.yellow, asc, fm, false);
						}
					}
				}

				if(!Display.frame.BP.isDisplayingSol)
				{
					for(int j=0; j < getMatRedTmpSize(); j++)
					{
						int ni = (int)getMatRedTmp(j).getNum(1);
						int nj = (int)getMatRedTmp(j).getNum(2);

						int yd = margin + (ni-1) * ecart + 1;
						int xd = margin + (nj-1) * ecart + 1;

						g.setColor(Color.red);
						g.fillRect(xd, yd, ecart-1, ecart-1);
					}
				}
			}
			else
			{
				for(int j=0; j < getMatBlueSize(); j++)
				{
					int ni = (int)getMatBlue(j).getNum(1);
					int nj = (int)getMatBlue(j).getNum(2);

					if((isElemDisplayed(ni,nj) || isElemDisplayed(nj,ni)) || all)
					{

						int xd = margin + (ni-1) * ecart + 1;
						int yd = margin + (nj-1) * ecart + 1;

						g.setColor(Color.blue);
						g.fillRect(xd, yd, ecart-1, ecart-1);

						if(nj != ni)
						{
							g.fillRect(yd, xd, ecart-1, ecart-1);
						}

						if(70 <= Display.frame.ZP.getValue())
						{
							printValue(g, ni, nj, xd, yd, Color.yellow, asc, fm, true);
						}

					}
				}

				for(int j=0; j < getMatRedSize(); j++)
				{
					int ni = (int)getMatRed(j).getNum(1);
					int nj = (int)getMatRed(j).getNum(2);

					int xd = margin + (ni-1) * ecart + 1;
					int yd = margin + (nj-1) * ecart + 1;

					g.setColor(Color.red);
					g.fillRect(xd, yd, ecart-1, ecart-1);

					if(nj != ni)
					{
						xd = margin + (nj-1) * ecart + 1;
						yd = margin + (ni-1) * ecart + 1;
						g.fillRect(xd, yd, ecart-1, ecart-1);
					}
				}

				for(int j=0; j < getMatGreenSize(); j++)
				{
					int ni = (int)getMatGreen(j).getNum(1);
					int nj = (int)getMatGreen(j).getNum(2);

					int xd = margin + (ni-1) * ecart + 1;
					int yd = margin + (nj-1) * ecart + 1;

					g.setColor(Color.green);
					g.fillRect(xd, yd, ecart-1, ecart-1);

					if(nj != ni)
					{
						xd = margin + (nj-1) * ecart + 1;
						yd = margin + (ni-1) * ecart + 1;
						g.fillRect(xd, yd, ecart-1, ecart-1);
					}

					if(70 <= Display.frame.ZP.getValue())
					{
						printValue(g, ni, nj, xd, yd, Color.red, asc, fm, true);
					}
				}

				for(int j=0; j < getMatGreenTmpSize(); j++)
				{
					int ni = (int)getMatGreenTmp(j).getNum(1);
					int nj = (int)getMatGreenTmp(j).getNum(2);

					int yd = margin + (ni-1) * ecart + 1;
					int xd = margin + (nj-1) * ecart + 1;

					g.setColor(Color.green);
					g.fillRect(xd, yd, ecart-1, ecart-1);

				}
			}



			for(int j=0; j < getVectBlueSize(); j++)
			{
				int nbr = getVectBlue(j);

				int xd = margin + (size + 2) * ecart + 1;
				int yd = margin + nbr * ecart + 1;

				g.setColor(Color.blue);
				g.fillRect(xd, yd, ecart-1, ecart-1);

				if(70 <= Display.frame.ZP.getValue())
				{
					printVectValue(g, nbr, xd, yd, Color.yellow, asc, fm);
				}

			}

			for(int j=0; j < getVectRedSize(); j++)
			{
				int nbr = getVectRed(j);

				int xd = margin + (size + 2) * ecart + 1;
				int yd = margin + nbr * ecart + 1;

				g.setColor(Color.red);
				g.fillRect(xd, yd, ecart-1, ecart-1);

			}

			for(int j=0; j < getVectGreenSize(); j++)
			{
				int nbr = getVectGreen(j);

				int xd = margin + (size + 2) * ecart + 1;
				int yd = margin + nbr * ecart + 1;

				g.setColor(Color.green);
				g.fillRect(xd, yd, ecart-1, ecart-1);

				if(70 <= Display.frame.ZP.getValue())
				{
					printVectValue(g, nbr, xd, yd, Color.red, asc, fm);
				}
			}
		}

		all = false;
	}
}
