package FEJDGui;
import FEJDMath.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.geom.*;
import javax.swing.border.*;

/** This panel displays the mesh and the temperature scale */
public class MeshPanel extends JPanel
{
	/** The mesh which is displayed */
	private Mesh m=null;
	/** The global number of the element which should be painted in red */
	private int ElemRed = -1;
	/** The boorder which should be painted in red */
	private MeshBorder BorderRed=null;
	/** The global number of the node which should be painted in red */
	private int NodeRed = -1;
	/** The level of refinement of the mesh */
	private int level=0;
	/** Stores if the boundary conditions should be displayed or not */
	private boolean isDispBC=true;
	private boolean isDispNb=false;

	/** Construcs a new mesh panel */
	public MeshPanel() {
		Border etched = BorderFactory.createEtchedBorder();
		Border titled = BorderFactory.createTitledBorder(etched, Display.frame.MB.getString("mesh"));
		setBorder(titled);
	}

	/** Updates the text upon language change */
	public void update() {
		Border etched = BorderFactory.createEtchedBorder();
		Border titled = BorderFactory.createTitledBorder(etched, Display.frame.MB.getString("mesh"));
		setBorder(titled);
	}

	/** Sets the mesh so it can be displayed */
	public void setMesh(Mesh nm) {
		m = nm;
	}

	/** Sets which element will be displayed in red */
	public void setElemRed(int ne){
		ElemRed = ne;
	}

	/** Sets which node will be displayed in red */
	public void setNodeRed(int ne) {
		NodeRed = ne;
	}

	/** Sets which border will be displayed in red */
	public void setBorderRed(MeshBorder ed) {
		BorderRed = ed;
	}
	/** Removes the red border */
	public void noRedBorder() {
		BorderRed=null;
	}

	/** Sets the level of refinement of the mesh */
	public void SetRefine(int nlevel) {
		level = nlevel;
	}

	/** Switches between displaying and not displaying the boundary conditions (dirichlet nodes and neumann with a=0, ie isolated) */
	public void changeDispBC() {
		isDispBC = !isDispBC;
		repaint();
	}

	/** Switches between displaying and not displaying the boundary conditions (dirichlet nodes and neumann with a=0, ie isolated) */
	public void changeDispNb() {
		isDispNb = !isDispNb;
		repaint();
	}

	/** Paints the components of the display */
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		setBackground(Color.white);

		Dimension dim = this.getSize();
		int largscreen = (int)dim.getWidth();
		int hautscreen = (int)dim.getHeight();
		int margin = 20;

		if(m != null) {

			// Temperature scale

			int ScWidth = 2 + largscreen/50;
			int TotHeight = hautscreen - 2*margin;
			int StartRect = largscreen - ScWidth - 40;
			Graphics2D g2 = (Graphics2D)g;
			Rectangle e1 = new Rectangle(StartRect, margin, ScWidth, TotHeight/4+1);
			Rectangle e2 = new Rectangle(StartRect, margin + TotHeight/4, ScWidth, TotHeight/4+1);
			Rectangle e3 = new Rectangle(StartRect, margin + TotHeight/2, ScWidth, TotHeight/4+1);
			Rectangle e4 = new Rectangle(StartRect, margin + (3*TotHeight/4), ScWidth, TotHeight/4);
			GradientPaint gp1 = new GradientPaint(StartRect, (int)e1.getY(), new Color(255,0,0), StartRect, (int)e2.getY(), new Color(255,255,0), false);
			GradientPaint gp2 = new GradientPaint(StartRect, (int)e2.getY(), new Color(255,255,0), StartRect, (int)e3.getY(), new Color(0,255,0), false);
			GradientPaint gp3 = new GradientPaint(StartRect, (int)e3.getY(), new Color(0,255,0), StartRect, (int)e4.getY(), new Color(0,255,255), false);
			GradientPaint gp4 = new GradientPaint(StartRect, (int)e4.getY(), new Color(0,255,255), StartRect, margin + TotHeight, new Color(0,0,255), false);
			g2.setPaint(gp1);
			g2.fill(e1);
			g2.setPaint(gp2);
			g2.fill(e2);
			g2.setPaint(gp3);
			g2.fill(e3);
			g2.setPaint(gp4);
			g2.fill(e4);

			// Mesh
			int zoom;

			double topx = 0;
			double topy = 0;
			double topcol = m.getMeshPoint(0).getTemperature();
			double mincol = m.getMeshPoint(0).getTemperature();

			for(int i=0; i < m.getNbOfMeshPoints(); i++) {
				if (m.getMeshPoint(i).getx() > topx)
					topx = m.getMeshPoint(i).getx();
				if (m.getMeshPoint(i).gety() > topy)
					topy = m.getMeshPoint(i).gety();

				if (m.getMeshPoint(i).getTemperature() > topcol)
					topcol = m.getMeshPoint(i).getTemperature();
				if (m.getMeshPoint(i).getTemperature() < mincol)
					mincol = m.getMeshPoint(i).getTemperature();
			}

			// Displaying of the temperature scale
			int nbGrad = 5;
			if(Display.frame.BP.isDisplayingSol)
				for(int i=0; i<nbGrad; i++) {
					g.setColor(Color.black);
					g.drawLine(StartRect, margin+i*TotHeight/(nbGrad-1)-1, StartRect+ScWidth+2, margin+i*TotHeight/(nbGrad-1)-1);
					g.drawString("" + (int)(topcol-i*((topcol-mincol)/(nbGrad-1))), StartRect+ScWidth+4, margin+i*TotHeight/(nbGrad-1)+5);
				}

			double zoomx = (double)(largscreen - 2 * margin - (ScWidth + 40))/topx;
			double zoomy = (double)(hautscreen - 2 * margin)/topy;

			if (zoomx < zoomy)
				zoom = (int)zoomx;
			else
				zoom = (int)zoomy;

			double amplitude = topcol - mincol;

			/* The array of elements whoses elements are actually painted on the display */
			Elem[] WorkingElemArray;

			if(Display.frame.BP.isDisplayingSol)
				WorkingElemArray = Display.frame.RP.storeElemArray[Math.min(level,Display.frame.RP.levelReached)];
			else
				WorkingElemArray = m.getAllElem();

			if(WorkingElemArray == null)
			{
				System.out.println(Display.frame.BP.isDisplayingSol);
			}

			for(int i=0; i < WorkingElemArray.length; i++) {

				int size = WorkingElemArray[i].getNumberOfNodes();
				Polygon P = new Polygon();
				double colmodif=0;

				for(int j=0; j < size; j++) {
					int x1 = margin + (int)(WorkingElemArray[i].getMeshPoint(j).getx() * zoom);
					int y1 = (int)(topy * zoom + margin - WorkingElemArray[i].getMeshPoint(j).gety() * zoom);
					P.addPoint(x1,y1);
					colmodif += WorkingElemArray[i].getMeshPoint(j).getTemperature();
				}

				colmodif = colmodif/(double)size;

				if(i == ElemRed)
					g.setColor(Color.red);
				else {
					int cmodif;
					if (amplitude != 0)
						cmodif = (int)((colmodif - mincol) * 1021 / amplitude);
					else
						cmodif = 0;

					if (cmodif < 0)
						g.setColor(Color.black);
					else if (cmodif < 256)
						g.setColor(new Color(50, cmodif, 255));
					else if (cmodif < 511)
						g.setColor(new Color(50, 255, 510 - cmodif));
					else if (cmodif < 766)
						g.setColor(new Color(cmodif - 510, 255, 50));
					else if (cmodif < 1022)
						g.setColor(new Color(255, 1021 - cmodif, 50));
				}

				g.fillPolygon(P);
				if(!Display.frame.BP.isDisplayingSol) {
					g.setColor(Color.black);
					g.drawPolygon(P);
				}

			}

			if (isDispBC) {
				Graphics2D g2d = (Graphics2D)g;
				g2d.setStroke(new BasicStroke(5));
				g2d.setColor(Color.black);
				for (int i=0; i < m.getNbOfBorderDomains(); i++) // boundary condition 2nd type
					if (m.getBorderDomain(i).getType() == 2) {
						int nbBor = m.getBorderDomain(i).getNbOfBorders();
						for (int j=0; j < nbBor; j++) {
							Border2 ed = (Border2)m.getBorderDomain(i).getBorder(j);
							if (ed.geta() == 0) {
								int ex1 = margin + (int)(ed.getMeshPoint(0).getx() * zoom);
								int ey1 = (int)(topy * zoom + margin - ed.getMeshPoint(0).gety() * zoom);
								int ex2 = margin + (int)(ed.getMeshPoint(1).getx() * zoom);
								int ey2 = (int)(topy * zoom + margin - ed.getMeshPoint(1).gety() * zoom);
								g2d.drawLine(ex1,ey1,ex2,ey2);
							}
						}
					}
				g2d.setStroke(new BasicStroke(1)); // otherwise problems with the nodes in the following loop
			}



			if(BorderRed != null) {
				int ex1 = margin + (int)(BorderRed.getMeshPoint(0).getx() * zoom);
				int ey1 = (int)(topy * zoom + margin - BorderRed.getMeshPoint(0).gety() * zoom);
				int ex2 = margin + (int)(BorderRed.getMeshPoint(1).getx() * zoom);
				int ey2 = (int)(topy * zoom + margin - BorderRed.getMeshPoint(1).gety() * zoom);

				Graphics2D g2d = (Graphics2D)g;
				int width = 6;
				g2d.setStroke(new BasicStroke(width));
				g2d.setColor(Color.red);
				g2d.drawLine(ex1,ey1,ex2,ey2);
				g2d.setStroke(new BasicStroke(1)); // otherwise problems with the nodes in the following loop
			}

			// Dirichlet nodes
			for(int i =0; i < m.getNbOfMeshPoints(); i++) {
				if(m.getMeshPoint(i).isDirichletNode()) {
					int x = margin + (int)(m.getMeshPoint(i).getx() * zoom);
					int y = (int)(topy * zoom + margin - m.getMeshPoint(i).gety() * zoom);
					int rayon = Math.min(largscreen, hautscreen)/50;

					if(i == NodeRed) {
						g.setColor(Color.red);
						g.fillOval(x-(2*rayon)/2,y-(2*rayon)/2,2*rayon,2*rayon);
						g.setColor(Color.black);
						g.drawOval(x-(2*rayon)/2,y-(2*rayon)/2,2*rayon,2*rayon);
					}
					else if(isDispBC) {
						g.setColor(Color.green);
						g.fillOval(x-rayon/2,y-rayon/2,rayon,rayon);
						g.setColor(Color.black);
						g.drawOval(x-rayon/2,y-rayon/2,rayon,rayon);
					}
				}
			}

			if (isDispNb) {
				g.setColor(new Color(255,0,255));
				Font f = new Font("SansSerif", Font.BOLD, 11);
				g.setFont(f);
				FontMetrics fm = g.getFontMetrics(f);
				int asc = fm.getAscent();

				for(int i =0; i < m.getNbOfMeshPoints(); i++) {
					MeshPoint mp = m.getMeshPoint(i);
					String num = Integer.toString(mp.getGlobalNb());
					int swidth = fm.stringWidth(num);
					int x = margin + (int)(mp.getx() * zoom);
					int y = (int)(topy * zoom + margin - mp.gety() * zoom);
					g.drawString(num, x-swidth/2, y+asc/2);
				}
			}

		}
	}
}
