package FEJDGui;
import FEJDMath.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** This panel contains a scrollbar  that lets the user choose degree of refinement of the display of temperature on the mesh */
public class RefinePanel extends JPanel implements AdjustmentListener {

	/** The scroll bar which sets the level of refinement */
	private JScrollBar refine;
	/** The progress label */
	private JLabel refineLabel;
	/** The level of refinement hich has been reached */
	public int levelReached=0;
	/** The array storing the elements of every level of refinement */
	public Elem[][] storeElemArray;
	/** The progress bar which shows the progress of the refinement */
	public static JProgressBar pb;
	/** Stores if the thread doing the refinement is allowed to run */
	private boolean threadRefineAllowed = false;
	/** The level a which the refinement start after reload */
	private int startlevel=0;
	/** The thread used to refine the picture */
	private RefineColorThread refineColorThread;
	/** True if the only thread created is the one created in the constructor */
	private boolean firstThread;
	/** Construcs and initializes a new refine panel */
	public RefinePanel() {

		levelReached=0;

		GridBagLayout gbl = new GridBagLayout();
		GridBagConstraints gbc = new GridBagConstraints();
		setLayout(gbl);
		Insets in = gbc.insets;

		in.left = 30;
		in.right = 10;
		gbc.weightx = 0;
		refineLabel = new JLabel(Display.frame.MB.getString("Interpolation") + " :");
		gbl.setConstraints(refineLabel, gbc);
		add(refineLabel);


		in.left = 10;
		in.right = 10;
		in.top = 5;
		in.bottom = 5;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 1.0;

		refine = new JScrollBar(Adjustable.HORIZONTAL, startlevel, 1, 0, 7);
		refine.setBlockIncrement(1);
		refine.setEnabled(false);
		refine.setToolTipText(Display.frame.MB.getString("Refine_ttt"));
		Display.frame.MeP.SetRefine(startlevel);
		refine.addAdjustmentListener(this);
		gbl.setConstraints(refine, gbc);
		add(refine);

		in.left = 10;
		in.right = 30;
		gbc.weightx = 0;
		pb = new JProgressBar(0, 100);
		gbl.setConstraints(pb, gbc);
		add(pb);

		refineColorThread = new RefineColorThread();
		firstThread = true;
	}

	/** Sets the state of the scroll bar */
	public void setRefineSBEnabled(boolean b) {
		refine.setEnabled(b);
	}

	/** REacts to a change in the value of the refinement scroll bar */
	public void adjustmentValueChanged(AdjustmentEvent evt) {
		Display.frame.MeP.SetRefine(refine.getValue());
		if (levelReached < refine.getValue()) {
			threadRefineAllowed = true;
			if (!refineColorThread.isAlive()) {
				if (!firstThread)
					refineColorThread = new RefineColorThread();
				refineColorThread.setGoal(refine.getValue());
				refineColorThread.start();
				firstThread = false;
			}
			else {
				refineColorThread.setGoal(refine.getValue());
			}


		}
		else {
			stopThread();
			pb.setValue(0);
		}
		Display.frame.MeP.repaint();
	}

	/** Updates the labels when the user changes the language */
	public void update() {
		refineLabel.setText(Display.frame.MB.getString("Interpolation") + " :");
		refine.setToolTipText(Display.frame.MB.getString("Refine_ttt"));
	}

	/** Clears the arrays */
	public void LoadButton() {
		storeElemArray = new Elem[10][];
		levelReached = 0;
		pb.setValue(0);
		refine.setValue(0);
		refine.setMaximum(7);
		refine.setEnabled(false);
		Display.frame.MeP.SetRefine(startlevel);
	}

	/** Stops the thread */
	public void stopThread() {
		threadRefineAllowed = false;
		Thread.yield(); // to let them terminate
	}

	/** Returns true if the refining thread is allowed to run */
	public boolean isThreadRefineAllowed() {
		return threadRefineAllowed;
	}

	/** Converts a MeshPoint to a Node for the displaying of the mesh */
	private Node MeshPoint2Node(MeshPoint mp) {
		return new Node(mp.getGlobalNb(), mp.getx(), mp.gety(), mp.getTemperature());
	}

	/** Modifies the mesh so that it is compatible with the linear version of the DisplayPanel ie devides the triangle formed of 3 MeshPoints and 3 Nodes to four triangles formed of 3 nodes, this function does nothing if linear functions are used  */
	public void makeSimpleTriangle(Elem[] tbl) {
		if(MathStuff.getMesh().getElemType() == Data.TRIANGLE && MathStuff.getMesh().getFctType() == Data.QUADRATIC) {

			Elem[] ntbl = new Elem[tbl.length*4];
			for (int i =0; i < tbl.length; i++) {

			// in tbl[i] :	getNode[3] is between getMeshPoint[0] and getMeshPoint[1]
			//		getNode[4] is between getMeshPoint[1] and getMeshPoint[2]
			//		getNode[5] is between getMeshPoint[0] and getMeshPoint[2]

				Node n0 = MeshPoint2Node(tbl[i].getMeshPoint(0));
				Node n1 = MeshPoint2Node(tbl[i].getMeshPoint(1));
				Node n2 = MeshPoint2Node(tbl[i].getMeshPoint(2));
				Node n3 = MeshPoint2Node(tbl[i].getMeshPoint(3));
				Node n4 = MeshPoint2Node(tbl[i].getMeshPoint(4));
				Node n5 = MeshPoint2Node(tbl[i].getMeshPoint(5));

				ntbl[i*4] = new Triangle(0, n0, n3, n5);
				ntbl[i*4+1] = new Triangle(0, n1, n3, n4);
				ntbl[i*4+2] = new Triangle(0, n2, n5, n4);
				ntbl[i*4+3] = new Triangle(0, n3, n5, n4);
			}
			storeElemArray[0] = ntbl;
		}
		else if(MathStuff.getMesh().getElemType() == Data.QUADRILATERAL && MathStuff.getMesh().getFctType() == Data.LINEAR)
		{
			Elem[] ntbl = new Elem[tbl.length*2];

			for (int i =0; i < tbl.length; i++) {
				Node n0 = MeshPoint2Node(tbl[i].getMeshPoint(0));
				Node n1 = MeshPoint2Node(tbl[i].getMeshPoint(1));
				Node n2 = MeshPoint2Node(tbl[i].getMeshPoint(2));
				Node n3 = MeshPoint2Node(tbl[i].getMeshPoint(3));

				ntbl[i*2] = new Triangle(0, n0, n1, n2);
				ntbl[i*2+1] = new Triangle(0, n0, n2, n3);
			}
			storeElemArray[0] = ntbl;
		}
		else if(MathStuff.getMesh().getElemType() == Data.QUADRILATERAL && MathStuff.getMesh().getFctType() == Data.QUADRATIC)
		{
			Elem[] ntbl = new Elem[tbl.length*8];

			for (int i =0; i < tbl.length; i++) {
				Node n0 = MeshPoint2Node(tbl[i].getMeshPoint(0));
				Node n1 = MeshPoint2Node(tbl[i].getMeshPoint(1));
				Node n2 = MeshPoint2Node(tbl[i].getMeshPoint(2));
				Node n3 = MeshPoint2Node(tbl[i].getMeshPoint(3));
				Node n4 = MeshPoint2Node(tbl[i].getMeshPoint(4));
				Node n5 = MeshPoint2Node(tbl[i].getMeshPoint(5));
				Node n6 = MeshPoint2Node(tbl[i].getMeshPoint(6));
				Node n7 = MeshPoint2Node(tbl[i].getMeshPoint(7));
				Node n8 = MeshPoint2Node(tbl[i].getMeshPoint(8));

				ntbl[i*8] = new Triangle(0, n0, n4, n8);
				ntbl[i*8+1] = new Triangle(0, n0, n8, n7);
				ntbl[i*8+2] = new Triangle(0, n7, n8, n6);
				ntbl[i*8+3] = new Triangle(0, n7, n6, n3);
				ntbl[i*8+4] = new Triangle(0, n4, n1, n5);
				ntbl[i*8+5] = new Triangle(0, n4, n5, n8);
				ntbl[i*8+6] = new Triangle(0, n8, n5, n2);
				ntbl[i*8+7] = new Triangle(0, n8, n2, n6);
			}
			storeElemArray[0] = ntbl;


		}
		else // TRIANGLE / LINEAR
			storeElemArray[0] = tbl;
	}

	/** Refines the mesh so the picture is better */
	public synchronized void refineColor(boolean lastLevel) {
		int j=0;
		while(j<10 && storeElemArray[j] != null)
			j++;
		j--;

		if(levelReached <= j) {

			try {
				Elem[] tbl = storeElemArray[j];

				if (lastLevel) {
					pb.setStringPainted(true);
					pb.setValue(0);
					pb.setMaximum(tbl.length-1);
				}

				Elem[] ntbl = new Elem[tbl.length*4];

				for(int i =0; i < tbl.length && threadRefineAllowed; i++) {
					if (lastLevel)
						pb.setValue(i);

					Node n0 = tbl[i].getNode(0);
					Node n1 = tbl[i].getNode(1);
					Node n2 = tbl[i].getNode(2);

					double av01x = (n0.getx() + n1.getx())/2.;
					double av01y = (n0.gety() + n1.gety())/2.;
					double av01temp = (n0.getTemperature() + n1.getTemperature())/2.;

					double av02x = (n0.getx() + n2.getx())/2.;
					double av02y = (n0.gety() + n2.gety())/2.;
					double av02temp = (n0.getTemperature() + n2.getTemperature())/2.;

					double av12x = (n1.getx() + n2.getx())/2.;
					double av12y = (n1.gety() + n2.gety())/2.;
					double av12temp = (n1.getTemperature() + n2.getTemperature())/2.;

					Node n01 = new Node(0, av01x, av01y, av01temp);
					Node n02 = new Node(0, av02x, av02y, av02temp);
					Node n12 = new Node(0, av12x, av12y, av12temp);

					ntbl[i*4] = new Triangle(0, n0, n01, n02);
					ntbl[i*4+1] = new Triangle(0, n1, n01, n12);
					ntbl[i*4+2] = new Triangle(0, n2, n12, n02);
					ntbl[i*4+3] = new Triangle(0, n01, n12, n02);
					Thread.yield();
				}
				if (threadRefineAllowed) {
					storeElemArray[j+1] = ntbl;
					levelReached = j+1;
				}
				pb.setStringPainted(false);

			}
			catch (OutOfMemoryError e) {
				storeElemArray[j+1] = null;
				String msg = Display.frame.MB.getString("MemoryErrorMsg");
				String title = Display.frame.MB.getString("MemoryError");
				JOptionPane.showMessageDialog(null, msg, title, JOptionPane.ERROR_MESSAGE);
				threadRefineAllowed = false;
				refine.setValue(levelReached);
				refine.setMaximum(levelReached + refine.getVisibleAmount());
			}
		}
	}

}
