package FEJDGui;
import FEJDMath.*;

/** This thread is used to wait for the makeMatThread to stop before displaying the result dialog */
public class RenumResultThread extends Thread
{
	/** The size of the matrix before renumbering */
	private int before;
	/** true if the dialog should be displayed */
	private boolean displaysBA;
	/** Step of the solving process */
	private int step;

	/** @param before The size of the matrix before renumbering
	@param displaysBA set to true if the dialog should be displayed at the end 
	@param step Step of the solving process that the programm has to wait before the display of the dialog box */
	public RenumResultThread(int before, boolean displaysBA, int step) {
		this.before = before;
		this.displaysBA = displaysBA;
		this.step = step;
	}

	/** Waits for the thread to finish and displays the dialog if needed */
	public void run() {

		if ( Display.frame.BP.isRenumberThreadAllowed() )
			Display.frame.BP.matButtonAction();
		while (MathStuff.isMatThreadAlive()) {
			try {Thread.sleep(10);}
			catch (Exception e) {}
		}

		if (step>1) {
			if (Display.frame.BP.isRenumberThreadAllowed() )
				Display.frame.BP.bc2ButtonAction();
			while (MathStuff.isBCT2ThreadAlive()) {
				try {Thread.sleep(10);}
				catch (Exception e) {}
			}
		}

		if (step>2) {
			if (Display.frame.BP.isRenumberThreadAllowed() )
				Display.frame.BP.bc3ButtonAction();
			while (MathStuff.isBCT3ThreadAlive()) {
				try {Thread.sleep(10);}
				catch (Exception e) {}
			}
		}

		if (step>3) {
			if (Display.frame.BP.isRenumberThreadAllowed() )
				Display.frame.BP.bc1ButtonAction();
			while (MathStuff.isBCT1ThreadAlive()) {
				try {Thread.sleep(10);}
				catch (Exception e) {}
			}
		}

   	if (step>4) {
			if (Display.frame.BP.isRenumberThreadAllowed() )
				Display.frame.BP.solButtonAction();
			while (MathStuff.isSolThreadAlive()) {
				try {Thread.sleep(10);}
				catch (Exception e) {}
			}
		}

		if (displaysBA && Display.frame.BP.isRenumberThreadAllowed()) {
			int after = MathStuff.getSkylineSize();
			ResultsDialog rd = new ResultsDialog(null, before, after);
			rd.show();
		}

	}

}
