package FEJDGui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** DialogBox that displays the results of the renumbering (size of the profile before and after) */
class ResultsDialog extends JDialog {
	/** @param parent the parent frame of the dialog
	@param before the size of the matrix before the renumbering
	@param after the size of the matrix after renumbering */
	public ResultsDialog(JFrame parent, int before, int after) {
		super(parent, Display.frame.MB.getString("Results"), true);
		Box b = Box.createVerticalBox();
		b.add(Box.createGlue());
		b.add(new JLabel("    " + Display.frame.MB.getString("oldsize") + " :  " + before));
		b.add(Box.createGlue());
		b.add(new JLabel("    " + Display.frame.MB.getString("newsize") + " :  " + after));
		b.add(Box.createGlue());
		getContentPane().add(b, "Center");

		JPanel p2 = new JPanel();
		JButton ok = new JButton("Ok");
		p2.add(ok);
		getContentPane().add(p2, "South");

		ok.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				setVisible(false);
			}
		});

		setBounds(200, 200, 400, 150);
	}
}
