package FEJDGui;

import java.awt.*;
import javax.swing.*;

/** This class draws the ruler on the side of the matrix */
public class RulerPanel extends JPanel
{
	int preferredh = 20;
	int preferredw = 40;

	private int orientation;

	/** Creates a new RulerPanel
	@param orientation sets the orientation of the panel 0 for vertical 1 for horizontal */
	public RulerPanel(int orientation)
	{
		this.orientation = orientation;
		if(orientation == 1)
			setPreferredSize(new Dimension(100,preferredh));
		else
			setPreferredSize(new Dimension(preferredw,100));
	}

	/** Draws the ruler */
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		setBackground(Color.white);
		int size = Display.frame.MaP.getSizeMat();
		int margin = Display.frame.MaP.getMargin();
		int gap = Display.frame.ZP.getValue();
		//g.clearRect(0,0,getWidth(),getHeight());
		Font f = new Font("SansSerif", Font.PLAIN, 14);
		g.setFont(f);
		FontMetrics fm = g.getFontMetrics(f);
		int asc = fm.getAscent();

		if(orientation == 1 && 30 < gap )
		{
			for(int i=0; i < size; i++)
			{
				String num = String.valueOf(i+1);
				int swidth = fm.stringWidth(num);
				g.drawString(num,margin+i*gap+(gap-swidth)/2,(preferredh+asc)/2);
			}
		}
		else if(orientation == 0 && 30 < gap )
		{
			for(int i=0; i < size; i++)
			{
				String num = String.valueOf(i+1);
				int swidth = fm.stringWidth(num);
				g.drawString(num,(preferredw-swidth)/2,margin+i*gap+(gap+asc)/2);
			}
		}
	}

	public Dimension getPreferredSize() {
		if(orientation == 1)
			return new Dimension((int)Display.frame.MaP.getPreferredSize().getWidth(), preferredh);
		else
			return new Dimension(preferredw, (int)Display.frame.MaP.getPreferredSize().getHeight());
	}
}
