package FEJDGui;
import FEJDMath.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.File;
import java.util.Vector;

/** Panel used to select and load the files .dat and .net */
public class WebLoadPanel extends JPanel implements ActionListener, OurLoadPanel {

	/** The text fields where the filenames are entered */
	public JTextField tf1,tf2;
	/** Button to load the two files  */
	private JButton loadBtn;
	/** Names of the .net files */
	private String[] netFileName;
	/** Names of the .dat files */
	private String[] datFileName;
	/** List displaying the .net files */
	private JList netList;
	/** List displaying the .dat files */
	private JList datList;

	/** Constructs and initialises a new load panel */
	public WebLoadPanel() {

		datList = new JList();

		JApplet applet = Display.frame.getApplet();
		int nbOfNetFiles = Integer.parseInt(applet.getParameter("nbOfNetFiles"));
		int nbOfDatFiles = Integer.parseInt(applet.getParameter("nbOfDatFiles"));

		Vector files = new Vector();
		for(int i=1; i <= nbOfNetFiles; i++)
		{
			files.add(applet.getParameter("netFile" + Integer.toString(i)));
		}
		netList = new JList(files);

		files = new Vector();
		for(int i=1; i <= nbOfDatFiles; i++)
		{
			files.add(applet.getParameter("datFile" + Integer.toString(i)));
		}
		datList = new JList(files);


		loadBtn = new JButton(Display.frame.MB.getString("Load"));
		loadBtn.addActionListener(this);
		loadBtn.setAlignmentX(0.5F);
		datList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		datList.setSelectedIndex(0);
		datList.setAlignmentX(0.5F);
		netList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		netList.setSelectedIndex(0);
		netList.setAlignmentX(0.5F);


		Box b = Box.createVerticalBox();
		b.add(Box.createVerticalStrut(15));
		b.add(netList);
		b.add(Box.createVerticalStrut(15));
		b.add(datList);
		b.add(Box.createVerticalStrut(15));
		b.add(loadBtn);

		add(b);
	}

	/** Adds a component to the display */
	private void add(Component c, GridBagConstraints gbc, int x, int y, int w, int h) {
		gbc.gridx = x;
		gbc.gridy = y;
		gbc.gridwidth = w;
		gbc.gridheight = h;
		add(c, gbc);
	}

	/** Upadtes the text upon language change */
	public void update() {
		loadBtn.setText(Display.frame.MB.getString("Load"));
	}

	/** Changes the value of the text field */
	private void setFieldTxt(JTextField tf, String txt) {
	}

	/** Sets the selected net file to filetxt */
	public void setNetFile(String filetxt) {
	}

	/** Sets the selected net file to filetxt */
	public void setDatFile(String filetxt) {
	}

	/** Reponds to the user's click on a button */
	public void actionPerformed(ActionEvent ae) {
		Object quelle = ae.getSource();

		if (quelle == loadBtn)
			loadButtonAction();
	}

	/** Performs the action of the load button */
	public void loadButtonAction() {
		Display.frame.BP.stopAllThreads();
		Display.frame.RP.stopThread();

		if (Display.frame.MB.isLinearFctSelected())
			MathStuff.setMesh(new Mesh(Data.LINEAR));
		else if (Display.frame.MB.isQuadraticFctSelected())
			MathStuff.setMesh(new Mesh(Data.QUADRATIC));

		Readers reader = new Readers();

		JApplet applet = Display.frame.getApplet();

		reader.readFile(MathStuff.getMesh(), applet.getCodeBase() + (String)netList.getSelectedValue(),applet.getCodeBase() + (String)datList.getSelectedValue(), true);
		/*reader.readFile(MathStuff.getMesh(), this.getClass().getClassLoader().getResource((String)netList.getSelectedValue()), this.getClass().getClassLoader().getResource((String)datList.getSelectedValue()), true);*/
		Mesh m = MathStuff.getMesh();

		if (m != null) {
			Display.frame.MeP.setMesh(m);
			Display.frame.MaP.setMesh(m.getSize());

			Display.frame.BP.LoadButton();
			Display.frame.MB.setRefinementEnabled(false);
			Display.frame.MB.setSolutionEnabled(false);
			Display.frame.MB.setJpegEnabled(true);
			Display.frame.MB.setNewFileRenumEnabled(true);

			Display.frame.RP.LoadButton();
			Display.frame.BP.isDisplayingSol = false;
			Display.frame.BP.isTimeToDisplayLU = false;

			Display.frame.MaP.emptyVect();
			Display.frame.MaP.emptyMat();

			Display.frame.MeP.repaint();
			Display.frame.MaP.repaint();

			Display.frame.CP.clear();
		}
	}
	
	/** Returns the path of the selected file without .net */
	public String getSelectNetPath() {
		return "";
	}

	/** Returns the name of the selected file without .dat */
	public String getSelectDatPath() {
		return "";
	}

}
