package FEJDGui;
import FEJDMath.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.net.*;
import java.io.*;


/** Menu bar of the software */
public class WebMenuBar extends JMenuBar implements ActionListener, OurMenuBar {

	/** The different menus of the program */
	private JMenu menuLanguage, menuParam, menuFct, menuDisplay, menuMisc, menuAcc, menuHelp, menuNewFiles;
	/** The different menu items of the program */
	private JMenuItem eng, ger, fre, jpeg, solution, renum, refinement, about;
	/** The different checkbox menu items of the program */
	private JCheckBoxMenuItem nbDispl, dirichletNode, decompDispl, autoRenum, newFileRenum, newFileRefine, handbook;
	/** The different radiobutton menu items of the program */
	private JRadioButtonMenuItem linearFct, quadraticFct;
	/** The locals (ie languages) which are supported */
	private Locale[] localesSupported = {Locale.US, Locale.GERMANY, Locale.FRANCE};
	/** The language chossen by the user */
	private int localeChoosen = 0;
	/** The bundle containing all the strings in all languages */
	private static ResourceBundle rb;

	/** construcs and initializes a new menu bar and loads the help system */
	public WebMenuBar() {

		localeChoosen = 0;
		initLocale();

		menuLanguage = new JMenu(getString("Language"));
		eng = new JMenuItem(getString("english"));
		eng.addActionListener(this);
		menuLanguage.add(eng);
		eng.setEnabled(false);

		ger = new JMenuItem(getString("german"));
		ger.addActionListener(this);
		menuLanguage.add(ger);

		fre = new JMenuItem(getString("french"));
		fre.addActionListener(this);
		menuLanguage.add(fre);

		add(menuLanguage);

		menuParam = new JMenu(getString("Parameters"));

		menuFct = new JMenu(getString("FunType"));

		ButtonGroup FTGroup = new ButtonGroup();

		linearFct = new JRadioButtonMenuItem(getString("LinearFun"));
		linearFct.setSelected(true);
		FTGroup.add(linearFct);
		menuFct.add(linearFct);

		quadraticFct = new JRadioButtonMenuItem(getString("QuadraticFun"));
		FTGroup.add(quadraticFct);
		menuFct.add(quadraticFct);

		menuParam.add(menuFct);

		menuDisplay = new JMenu(getString("Display"));

		nbDispl = new JCheckBoxMenuItem(getString("NbDisplay"));
		nbDispl.setSelected(false);
		menuDisplay.add(nbDispl);
		nbDispl.addActionListener(this);

		dirichletNode = new JCheckBoxMenuItem(getString("BCDisplay"));
		dirichletNode.setSelected(true);
		menuDisplay.add(dirichletNode);
		dirichletNode.addActionListener(this);

		decompDispl = new JCheckBoxMenuItem(getString("DecompDispl"));
		decompDispl.setSelected(true);
		menuDisplay.add(decompDispl);
		decompDispl.addActionListener(this);

		menuParam.add(menuDisplay);

		menuMisc = new JMenu(getString("Misc"));

		autoRenum = new JCheckBoxMenuItem(getString("AutoRenum"));
		autoRenum.setSelected(true);
		menuMisc.add(autoRenum);

		menuParam.add(menuMisc);

		menuNewFiles = new JMenu(getString("NewFilesCreation"));

		newFileRenum = new JCheckBoxMenuItem(getString("NF_renumbering"));
		menuNewFiles.add(newFileRenum);
		newFileRefine = new JCheckBoxMenuItem(getString("NF_refinement"));
		menuNewFiles.add(newFileRefine);

		add(menuParam);

		menuAcc = new JMenu(getString("Accessories"));

		jpeg = new JMenuItem(getString("Create_Jpeg"));

		solution = new JMenuItem(getString("Save_Solution"));

		renum = new JMenuItem(getString("Renumbering"));
		renum.setAccelerator(KeyStroke.getKeyStroke("control " + getString("Renumbering").charAt(0)));
		renum.setEnabled(false);
		renum.addActionListener(this);
		menuAcc.add(renum);

		refinement = new JMenuItem(getString("Refinement"));

		add(menuAcc);

		menuHelp = new JMenu(getString("Help"));

		handbook = new JCheckBoxMenuItem(getString("Handbook"));
		handbook.addActionListener(this);
		menuHelp.add(handbook);

		about = new JMenuItem(getString("About") + " FEJavaDemo");
		about.addActionListener(this);
		menuHelp.add(about);

		add(menuHelp);
	}

	/** Initiates the default language */
	public void initLocale() {
		Locale localeCurrent = localesSupported[localeChoosen];
		this.setLocale(localeCurrent);
		rb = ResourceBundle.getBundle("lang", localeCurrent,this.getClass().getClassLoader());
	}

	/** Returns the string of the resource bundle */
	public String getString(String s) {
		return rb.getString(s);
	}

	/** Reacts to a click on a menu */
	public void actionPerformed(ActionEvent evt) {
		Object source = evt.getSource();
		if (source == eng) {
			localeChoosen = 0;
			initLocale();
			updateAll((JMenuItem)source);
		}

		else if (source == ger) {
			localeChoosen = 1;
			initLocale();
			updateAll((JMenuItem)source);
		}
		
		else if (source == fre) {
			localeChoosen = 2;
			initLocale();
			updateAll((JMenuItem)source);
		}
		
		else if (source == nbDispl)
			Display.frame.MeP.changeDispNb();
			
		else if (source == dirichletNode)
			Display.frame.MeP.changeDispBC();
			
		else if (source == decompDispl)
			Display.frame.MaP.changeDispDecomp();
			


		else if (source == renum) {
			MathStuff.clearAllTemp();
			Display.frame.BP.isTimeToDisplayLU = false;
			int step = Display.frame.BP.getState();
			Display.frame.BP.allowRenumberThread();
			Renumbering.McKee(MathStuff.getMesh(), newFileRenum.isSelected());
			Display.frame.BP.allowRenumberThread();
			Display.frame.BP.allowThread();
			Display.frame.BP.isDisplayingSol = false;
			if (step>0) {
				Display.frame.BP.disableAllButtons();
				int before = MathStuff.getSkylineSize();
				RenumResultThread rrt = new RenumResultThread(before, true, step);
				rrt.start();
			}
		}
		else if (source == handbook)
			Display.frame.CP.displayHTML();
		else if (source == about)
			Display.frame.AB.show();
	}

	/** Modifies the labels upon language change */
	public void updateAll(JMenuItem source) {
		Display.frame.BP.update();
		update(source);
		Display.frame.LP.update();
		Display.frame.frame.update();
		Display.frame.CP.update();
		Display.frame.MeP.update();
		Display.frame.ZP.update();
		Display.frame.RP.update();
		Display.frame.AB.update();
	}

	/** Updates the labels when the user changes the language */
	public void update(JMenuItem source) {
		eng.setEnabled(true);
		ger.setEnabled(true);
		fre.setEnabled(true);
		menuLanguage.setText(getString("Language"));
		eng.setText(getString("english"));
		ger.setText(getString("german"));
		fre.setText(getString("french"));
		source.setEnabled(false);
		menuParam.setText(getString("Parameters"));
		menuDisplay.setText(getString("Display"));
		nbDispl.setText(getString("NbDisplay"));
		dirichletNode.setText(getString("BCDisplay"));
		decompDispl.setText(getString("DecompDispl"));
		menuFct.setText(getString("FunType"));
		linearFct.setText(getString("LinearFun"));
		quadraticFct.setText(getString("QuadraticFun"));
		menuMisc.setText(getString("Misc"));
		autoRenum.setText(getString("AutoRenum"));
		menuNewFiles.setText(getString("NewFilesCreation"));
		newFileRenum.setText(getString("NF_renumbering"));
		newFileRefine.setText(getString("NF_refinement"));
		menuAcc.setText(getString("Accessories"));
		jpeg.setText(getString("Create_Jpeg"));
		solution.setText(getString("Save_Solution"));
		renum.setText(getString("Renumbering"));
		refinement.setText(getString("Refinement"));

		// Changes the shortcut for german..
		KeyStroke ks = KeyStroke.getKeyStroke(new Character(getString("Renumbering").charAt(0)), InputEvent.CTRL_MASK);
		renum.setAccelerator(ks);

		menuHelp.setText(getString("Help"));
		handbook.setText(getString("Handbook"));
		about.setText(getString("About") + " FEJavaDemo");
	}

	/** Returns true if the display help menu item is ticked */
	public boolean isDisplayingDoc()
	{
		return handbook.isSelected();
	}

	/** Returns true if the users has chosen to display the Cholesky-Factorization */
	public boolean isDisplDecomp() {
		return decompDispl.isSelected();
	}

	/** Returns true if the quadratic functions are selected */
	public boolean isQuadraticFctSelected()
	{
		return quadraticFct.isSelected();
	}

	/** Returns true if the linear functions are selected */
	public boolean isLinearFctSelected()
	{
		return linearFct.isSelected();
	}

	/** Sets the state of the save Jpeg menu */
	public void setJpegEnabled(boolean state)
	{
		jpeg.setEnabled(state);
	}

	/** Sets the save solution of the Jpeg menu */
	public void setSolutionEnabled(boolean state)
	{
		solution.setEnabled(state);
	}

	/** Sets the state of the refinement menu */
	public void setRefinementEnabled(boolean state)
	{
		refinement.setEnabled(state);
	}

	/** Sets the state of the renumbering menu */
	public void setRenumEnabled(boolean state)
	{
		renum.setEnabled(state);
	}

	/** Returns true if the auto-renumbering selected */
	public boolean isAutoRenumSelected()
	{
		return autoRenum.isSelected();
	}

	/** Returns true if the menu for creatig new files after a refinement is selected */
	public boolean isNewFileRefineSelected()
	{
		return newFileRefine.isSelected();
	}

	/** Sets the state of the menu for creating new files after a renumbering */
	public void setNewFileRenumEnabled(boolean state)
	{
		newFileRenum.setEnabled(state);
	}
}
