package FEJDGui;
import javax.swing.*;
import java.awt.*;

/** Frame which is displayed at the beginning of the program */
public class WelcomeBox extends JDialog implements Runnable
{

	/** Constructs a new WelcomeBox */
	public WelcomeBox(JFrame frame)
	{
		super(frame, false);
		setUndecorated(true);
		setResizable(false);

		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		int winwidth = 550;
		int winheight = 300;

		setBounds((dim.width-winwidth)/2, (dim.height-winheight)/2, winwidth, winheight);
		Panel panel = new Panel();
		panel.setBackground(new Color(220,220,255));

		ImageIcon imgIco = new ImageIcon(this.getClass().getClassLoader().getResource("gif/FEJD.jpeg"));

		JLabel imgLbl = new JLabel(imgIco);
		imgLbl.setAlignmentX(0.5F);
		JLabel l1 = new JLabel("erarbeitet von");
		l1.setAlignmentX(0.5F);
		l1.setFont(new Font("Serif", Font.PLAIN, 14));
		JLabel l2 = new JLabel("Aurlien Boffy und Jrmie Simon");
		l2.setAlignmentX(0.5F);
		l2.setFont(new Font("Serif", Font.BOLD, 16));
		JLabel l3 = new JLabel("(Ecole Nationale des Ponts et Chausses - Paris)");
		l3.setAlignmentX(0.5F);
		l3.setFont(new Font("Serif", Font.PLAIN, 14));
		JLabel l4 = new JLabel("unter Anleitung von");
		l4.setAlignmentX(0.5F);
		l4.setFont(new Font("Serif", Font.PLAIN, 14));
		JLabel l5 = new JLabel("Michael Jung und Kshitij Kulshreshtha");
		l5.setAlignmentX(0.5F);
		l5.setFont(new Font("Serif", Font.BOLD, 16));
		JLabel l6 = new JLabel("(Institut fr Wissenschaftliches Rechnen, Technische Universitt Dresden)");
		l6.setAlignmentX(0.5F);
		l6.setFont(new Font("Serif", Font.PLAIN, 14));

		Box b = Box.createVerticalBox();
		b.add(Box.createVerticalStrut(10));
		b.add(imgLbl);
		b.add(Box.createVerticalStrut(25));
		b.add(l1);
		b.add(Box.createVerticalStrut(10));
		b.add(l2);
		b.add(Box.createVerticalStrut(5));
		b.add(l3);
		b.add(Box.createVerticalStrut(20));
		b.add(l4);
		b.add(Box.createVerticalStrut(10));
		b.add(l5);
		b.add(Box.createVerticalStrut(5));
		b.add(l6);
		b.add(Box.createVerticalStrut(5));
		panel.add(b);

		Container contentPane = getContentPane();
		contentPane.add(panel);

		new Thread((Runnable)this).start();
	}

	/** Displays the box for 5 seconds and destroys it */
	public void run()
	{
		show();

		try
		{
			Thread.sleep(5000);
		}
		catch(InterruptedException e)
		{}

		dispose();
	}
}
