package FEJDGui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** This panel contains a scrollbar that lets the user choose how many case of the matrix he wants to see (the default value is the minimum between 75 and the number of nodes of the mesh) */
class ZoomPanel extends JPanel implements AdjustmentListener {

	/** The scroll bar used to set the zoom level of the matrix */
	private JScrollBar zoom;
	/** The zoom label */
	private JLabel zoomLabel;
	/** The minium value of the zoom */
	public int zoomMin = 3;

	/** Constructs and initilizes a new zomm panel */
	public ZoomPanel() {

		GridBagLayout gbl = new GridBagLayout();
		GridBagConstraints gbc = new GridBagConstraints();
		setLayout(gbl);
		Insets in = gbc.insets;

		in.left = 30;
		in.right = 10;
		gbc.weightx = 0;
		zoomLabel = new JLabel(Display.frame.MB.getString("Zoom") + " :");
		gbl.setConstraints(zoomLabel, gbc);
		add(zoomLabel);


		in.left = 10;
		in.right = 50;
		in.top = 5;
		in.bottom = 5;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 1.0;

		zoom = new JScrollBar(Adjustable.HORIZONTAL, 3, 10, zoomMin, 70+10);
		zoom.setToolTipText(Display.frame.MB.getString("Zoom_ttt"));
		zoom.addAdjustmentListener(this);
		gbl.setConstraints(zoom, gbc);
		add(zoom);

	}

	/** Reacts to a change in the value of the scroll bar */
	public void adjustmentValueChanged(AdjustmentEvent evt) {

		JScrollBar hsb = Display.frame.SP.getHorizontalScrollBar();
		int hmax = hsb.getMaximum();
		int hvalue = hsb.getValue();
		double hquo = (double)hvalue/(double)hmax;
		JScrollBar vsb = Display.frame.SP.getVerticalScrollBar();
		int vmax = vsb.getMaximum();
		int vvalue = vsb.getValue();
		double vquo = (double)vvalue/(double)vmax;

		Display.frame.MaP.recalcPanelSize(zoom.getMaximum() - zoom.getVisibleAmount() - zoom.getValue() + zoom.getMinimum());
		Display.frame.VRP.revalidate();
		Display.frame.HRP.revalidate();
		Display.frame.MaP.revalidate();
		Display.frame.validate();
		Display.frame.MaP.repaint();
		Display.frame.VRP.repaint();
		Display.frame.HRP.repaint();


		hmax = hsb.getMaximum();
		vmax = vsb.getMaximum();
		hsb.setValue((int)(hquo * hmax));
		vsb.setValue((int)(vquo * vmax));

	}

	/** Sets the value of the scroll bar to value */
	public void setValueScroll(int value) {
		zoom.setValue(zoom.getMaximum() - zoom.getVisibleAmount() - value + zoom.getMinimum());
	}

	/** Sets the maximum value of the scroll bar to value */
	/*public void setMaximumScroll(int value) {
		zoom.setMaximum(value);
	}*/

	/** Updates the labels when the user changes the language */
	public void update() {
		zoomLabel.setText(Display.frame.MB.getString("Zoom") + " :");
		zoom.setToolTipText(Display.frame.MB.getString("Zoom_ttt"));
	}

	/** Returns the value of the scroll bar */
	public int getValue() {
		return zoom.getMaximum() - zoom.getVisibleAmount() - zoom.getValue() + zoom.getMinimum();
	}

}
