package FEJDMath;
import FEJDGui.*;
/** The thread used to compute the boundary conditions of the second type */
class CalcBCT2Thread extends Thread
{
	/** The mesh on which the calulation is performed */
	private Mesh m;

	/** Construcs a new thread for calculating the boundary conditions of type 2 */
	public CalcBCT2Thread(Mesh m) {
		this.m = m;
	}

	/** Performs the calculation ie ask each border to compute its boundar conditions */
	public void run() {
		for(int i=0; i < m.getNbOfBorderDomains(); i++) { // boundary condition 2nd type
			if(!Display.frame.BP.isThreadAllowed()) // terminates the thread
				break;
			if(m.getBorderDomain(i).getType() == 2)
				m.getBorderDomain(i).calcAllBC();
		}

		if(Display.frame.BP.isThreadAllowed())
			Display.frame.BP.cleanUpBC2();
	}
}
