package FEJDMath;
import FEJDGui.*;

import java.util.*;

/** Represents a domain of the mesh, ie a group of elements having the same coefficients of thermal conductivity */
class Domain {

	/** Array containing the elements of the domain */
	private ArrayList elemArray;
	/** The coefficients of the domain */
	private double Kxx, Kyy;
	/** The global number of the domain */
	private int globalNb;

	/** @param nb the global number of the domain
	@param Kx the coefficient of thermal conductivity lambdaxx of the domain
	@param Ky the coefficient of thermal conductivity lambdayy of the domain */
	public Domain(int nb, double Kx, double Ky) {
		globalNb = nb;
		Kxx = Kx;
		Kyy = Ky;
	}

	/** Returns a description of the domain ie the coefficients of thermal conductivity and a description of each element */
	public String toString() {
		String s = "Domain "+ globalNb +" : " + Kxx + " " + Kyy + " - ";
		for (int i=0; i < elemArray.size(); i++)
			s += ((Elem)elemArray.get(i)).getGlobalNb() + " ";
		return s;
	}

	/** Returns the coefficient lambdaxx of the domain */
	public double getKxx() {
		return Kxx;
	}

	/** Returns the coefficient lambdayy of the domain */
	public double getKyy() {
		return Kyy;
	}

	/** Sets the domain to i elements */
	public void setNbOfElem (int i) {
		elemArray = new ArrayList(i);
		for (int k=0; k<i; k++)
			elemArray.add(k, null);
	}

	/** Sets the ith element of the domain to ed */
	public void setElem (int i, Elem el) {
		elemArray.set(i, el);
	}

	/** Adds the element el to the domain */
	public void addElem (Elem el) {
		elemArray.add(el);
	}

	/** Returns the ith element of the domain */
	public Elem getElem (int i) {
		return (Elem)elemArray.get(i);
	}

	/** Returns the number of elements of the domain */
	public int getNbOfElem() {
		return elemArray.size();
	}

	/** Computes the elementary stiffness matrix for every element of the domain */
	public void calcAllElementMatrix() {
		boolean flag=false;

		for(int i=0; i < elemArray.size(); i++) {
			
			if(!Display.frame.BP.isThreadAllowed()) // terminates the function
				break;

			Elem el = (Elem)elemArray.get(i);
			
	// Computing of the element matrices and element vectors :
			double[][] curMatrix = el.calcElementMatrix(Kxx, Kyy);
			double[] curVector = el.calcElementVector(globalNb);

	// Assembling :
			for(int j = 0; j < el.getNbOfMeshPoints(); j++) {
				int gNbj = el.getMeshPoint(j).getGlobalNb();

				MathStuff.addLVector(gNbj-1, curVector[j]);
				/* not displayed because otherwise the whole right hand side is blue
				if(gNbj-1 < Display.frame.MaP.SUPMAXMAT)
				{
					Display.frame.MP.setVectRed(gNbj-1);
					if(gNbj-1 < Display.frame.MaP.getSizeMat())
					{
						flag = true;
					}
				}*/

				for(int k = 0; k < el.getNbOfMeshPoints(); k++) {
					int gNbk = el.getMeshPoint(k).getGlobalNb();
					if(gNbk >= gNbj) {
						MathStuff.addSMatrix(gNbj, gNbk, curMatrix[j][k]);

	// Display :
						if(curMatrix[j][k] != 0) {
							Display.frame.MaP.setMatRed(gNbj, gNbk);
							if(Display.frame.MaP.isElemDisplayed(gNbj, gNbk) || Display.frame.MaP.isElemDisplayed(gNbk, gNbj))
								flag = true; // modification will be displayed
						}
					}
				}
			}

			if(flag && Mesh.TIMESLEEP > 0) {
				Display.frame.MeP.setElemRed(i);
				Display.frame.MaP.repaint();
				Display.frame.MeP.repaint();
				try { Thread.sleep(Mesh.TIMESLEEP); }
				catch(InterruptedException e){}
			}
			else {
				Display.frame.MeP.setElemRed(-1);
				Thread.yield();
			}
			Display.frame.MaP.insertMat();
			Display.frame.MaP.insertVect();
			flag=false;
		}
	}
}
