package FEJDMath;
import FEJDGui.*;

/** The thread used to assemble the matrix */
class MakeMatThread extends Thread
{
	/** The mesh on which the computation is performed */
	private Mesh m;

	/** Construts a new thread to assemble the matrix */
	public MakeMatThread(Mesh m) {
		this.m = m;
	}

	/** Makes the assembling of the matrix, ie call the assembling of every domain of the mesh */
	public void run() {
		for(int i=0; i < m.getNbOfDomains(); i++) {
			if(!Display.frame.BP.isThreadAllowed()) // terminates the thread
				break;
			m.getDomain(i).calcAllElementMatrix(); // and assemblies the SMatrix
		}

		if(Display.frame.BP.isThreadAllowed())
			Display.frame.BP.cleanUpMat();
	}
}
