package FEJDMath;
import FEJDGui.*;

/** The thread used to simulate the boundary conditions of the first type */
class SimulBCT1Thread extends Thread {

	/** The mesh on which the computation is performed */
	private Mesh m;
	/** The last vector */
	private double[] lastVector;
	/** The stiffness matrix */
	private SkyLine stiffnessMatrix;

	/** Construcs a new thread for simulating the boundary conditions of first type */
	public SimulBCT1Thread(Mesh m, double[] lastVector, SkyLine stiffnessMatrix) {
		this.m = m;
		this.lastVector = lastVector;
		this.stiffnessMatrix = stiffnessMatrix;
	}

	/** Performs the simulation, (ie highlight the rows and columns corresponding to dirichlet nodes), sets the diagonal entries of the matrix corresponding to dirichlet nodes to 1 and sets the values of the dirichlet nodes in the last vector */
	public void run() {

		for(int i=0; i < m.getNbOfMeshPoints(); i++) {
			if(!Display.frame.BP.isThreadAllowed()) // terminates the thread
				break;
			if(m.getMeshPoint(i).isDirichletNode()) {
				int gNb = m.getMeshPoint(i).getGlobalNb();
				stiffnessMatrix.set(gNb, gNb, 1); // set the diagonal entrie to 1
				lastVector[gNb-1] = m.getMeshPoint(i).getDirichletValue(); // set the value of the dirichlet node in the last vector

// Display :


				Display.frame.MaP.setVectGreen(gNb-1);
				Display.frame.MaP.setMatGreen(gNb, gNb);

				for(int l=1; l <= Display.frame.MaP.getSizeMat(); l++) {
					Display.frame.MaP.setMatGreenTmp(l, gNb);
					Display.frame.MaP.setMatGreenTmp(gNb, l);
				}

				if(Display.frame.MaP.isCrossDisplayed(gNb, gNb) && Mesh.TIMESLEEP > 0) {
					Display.frame.MeP.setNodeRed(i);
					Display.frame.MaP.repaint();
					Display.frame.MeP.repaint();
					try { Thread.sleep(Mesh.TIMESLEEP); }
					catch(InterruptedException e){}
				}
				else
					Thread.yield();

				Display.frame.MaP.clearGreenTmp();

			}
		}

		if (Display.frame.BP.isThreadAllowed())
			Display.frame.BP.cleanUpBC1();
	}
}
