package FEJDMath;
import FEJDGui.*;

/** The thread used to solve the problem */
class SolutionThread extends Thread {

	/** The mesh on which the calculation is performed */
	private Mesh m;
	/** The last vector */
	private double[] lastVector;
	/** The stiffness matrix */
	private SkyLine stiffnessMatrix;

	/** Constructs a new thread for solving the problem */
	public SolutionThread(Mesh m, double[] lastVector, SkyLine stiffnessMatrix) {
		this.m = m;
		this.lastVector = lastVector;
		this.stiffnessMatrix = stiffnessMatrix;
	}

	/** Solves the problem, ie calls the methods of skyline to make the decomposition and perform the back anf forward substitution, mesh points are then set to their right temperature */
	public void run() {

		if(!Display.frame.BP.isThreadAllowed()) // terminates the thread
			return;
		SkyLine S = new SkyLine(stiffnessMatrix.getVectorSize());
		stiffnessMatrix.computeLLT(S);

		if(!Display.frame.BP.isThreadAllowed()) // terminates the thread
			return;
		Display.frame.MaP.loadDecomp(S);
		Display.frame.BP.isTimeToDisplayLU = true;
		Display.frame.MaP.repaint();


		double[] sol =stiffnessMatrix.linSolve(lastVector); // solution of the problem

		for(int i=0; i < m.getNbOfMeshPoints(); i++) {

			if(!Display.frame.BP.isThreadAllowed()) // terminates the thread
				break;

			MeshPoint mp = m.getMeshPoint(i);
			mp.setTemperature(sol[mp.getGlobalNb()-1]);
		}

		if(Display.frame.BP.isThreadAllowed())
			Display.frame.BP.cleanUpSol(m.getFctType(), m.getElemType());
	}
}
